/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor;

import com.ygsoft.ecp.service.executor.AbstractMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedConcurrentHashMap
extends AbstractMap
implements ConcurrentMap,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_MAXIMUM_CAPACITY = 512;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    transient Set<Object> keySet;
    transient Set<Map.Entry> entrySet;
    transient Collection<Object> values;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public BoundedConcurrentHashMap(int capacity, int concurrencyLevel, Eviction evictionStrategy, EvictionListener evictionListener) {
        int cap;
        int ssize;
        if (capacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        concurrencyLevel = Math.min(capacity / 2, concurrencyLevel);
        if (capacity < (concurrencyLevel = Math.max(concurrencyLevel, 1)) * 2 && capacity != 1) {
            throw new IllegalArgumentException("Maximum capacity has to be at least twice the concurrencyLevel");
        }
        if (evictionStrategy == null || evictionListener == null) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (capacity > 0x40000000) {
            capacity = 0x40000000;
        }
        int c = capacity / ssize;
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, c, 0.75f, evictionStrategy, evictionListener);
        }
    }

    public BoundedConcurrentHashMap(int capacity, int concurrencyLevel) {
        this(capacity, concurrencyLevel, Eviction.LRU);
    }

    public BoundedConcurrentHashMap(int capacity, int concurrencyLevel, Eviction evictionStrategy) {
        this(capacity, concurrencyLevel, evictionStrategy, new NullEvictionListener());
    }

    public BoundedConcurrentHashMap(int capacity) {
        this(capacity, 16);
    }

    public BoundedConcurrentHashMap() {
        this(512, 16);
    }

    @Override
    public boolean isEmpty() {
        int i;
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            int i;
            sum = 0L;
            for (i = 0; i < segments.length; ++i) {
                segments[i].lock();
            }
            try {
                for (i = 0; i < segments.length; ++i) {
                    sum += (long)segments[i].count;
                }
            }
            finally {
                for (i = 0; i < segments.length; ++i) {
                    segments[i].unlock();
                }
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    @Override
    public Object get(Object key) {
        int hash = BoundedConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = BoundedConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        int i;
        if (value == null) {
            throw new NullPointerException();
        }
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int mcsum = 0;
            for (int i2 = 0; i2 < segments.length; ++i2) {
                int c = segments[i2].count;
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
                if (!segments[i2].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i3 = 0; i3 < segments.length; ++i3) {
                    int c = segments[i3].count;
                    if (mc[i3] == segments[i3].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (int i4 = 0; i4 < segments.length; ++i4) {
            segments[i4].lock();
        }
        boolean found = false;
        try {
            for (i = 0; i < segments.length; ++i) {
                if (!segments[i].containsValue(value)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (i = 0; i < segments.length; ++i) {
                segments[i].unlock();
            }
        }
        return found;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = BoundedConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = BoundedConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    @Override
    public Object remove(Object key) {
        int hash = BoundedConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        int hash = BoundedConcurrentHashMap.hash(key.hashCode());
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value) != null;
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash = BoundedConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public Object replace(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = BoundedConcurrentHashMap.hash(key.hashCode());
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    @Override
    public Set<Object> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<Object> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Enumeration<Object> keys() {
        return new KeyIterator();
    }

    public Enumeration<Object> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int k = 0; k < this.segments.length; ++k) {
            Segment seg = this.segments[k];
            seg.lock();
            try {
                HashEntry[] tab = seg.table;
                for (int i = 0; i < tab.length; ++i) {
                    HashEntry e = tab[i];
                    while (e != null) {
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
                continue;
            }
            finally {
                seg.unlock();
            }
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].setTable(new HashEntry[1]);
        }
        while (true) {
            Object key = s.readObject();
            Object value = s.readObject();
            if (key == null) break;
            this.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = BoundedConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return BoundedConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return BoundedConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BoundedConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            BoundedConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<Object> {
        Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return BoundedConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BoundedConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return BoundedConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            BoundedConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return BoundedConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return BoundedConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return BoundedConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return BoundedConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            BoundedConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry> {
        EntryIterator() {
        }

        @Override
        public Map.Entry next() {
            HashEntry e = super.nextEntry();
            return new WriteThroughEntry(e.key, e.value);
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry {
        private static final long serialVersionUID = -7041346694785573824L;

        WriteThroughEntry(Object k, Object v) {
            super(k, v);
        }

        public Object setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value);
            BoundedConcurrentHashMap.this.put(this.getKey(), value);
            return v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator<Object>,
    Enumeration<Object> {
        ValueIterator() {
        }

        @Override
        public Object next() {
            return super.nextEntry().value;
        }

        @Override
        public Object nextElement() {
            return super.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator<Object>,
    Enumeration<Object> {
        KeyIterator() {
        }

        @Override
        public Object next() {
            return super.nextEntry().key;
        }

        @Override
        public Object nextElement() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        HashEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = BoundedConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = BoundedConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            BoundedConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Segment
    extends ReentrantLock {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;
        final int evictCap;
        final transient EvictionPolicy eviction;
        final transient EvictionListener evictionListener;

        Segment(int cap, int evictCap, float lf, Eviction es, EvictionListener listener) {
            this.loadFactor = lf;
            this.evictCap = evictCap;
            this.eviction = es.make(this, evictCap, lf);
            this.evictionListener = listener;
            this.setTable(HashEntry.newArray(cap));
        }

        static Segment[] newArray(int i) {
            return new Segment[i];
        }

        EvictionListener getEvictionListener() {
            return this.evictionListener;
        }

        void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        Object readValueUnderLock(HashEntry e) {
            this.lock();
            try {
                Object object = e.value;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        Object get(Object key, int hash) {
            int c = this.count;
            if (c != 0) {
                Object result = null;
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        Object v = e.value;
                        if (v != null) {
                            result = v;
                            break;
                        }
                        result = this.readValueUnderLock(e);
                        break;
                    }
                    e = e.next;
                }
                if (result != null && this.eviction.onEntryHit(e)) {
                    Set<HashEntry> evicted = this.attemptEviction(false);
                    this.notifyEvictionListener(evicted);
                }
                return result;
            }
            return null;
        }

        boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        return true;
                    }
                    e = e.next;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                for (HashEntry e : this.table) {
                    while (e != null) {
                        Object v = e.value;
                        if (v == null) {
                            v = this.readValueUnderLock(e);
                        }
                        if (value.equals(v)) {
                            return true;
                        }
                        e = e.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(Object key, int hash, Object oldValue, Object newValue) {
            this.lock();
            Set<HashEntry> evicted = null;
            try {
                HashEntry e = this.getFirst(hash);
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                boolean replaced = false;
                if (e != null && oldValue.equals(e.value)) {
                    replaced = true;
                    e.value = newValue;
                    if (this.eviction.onEntryHit(e)) {
                        evicted = this.attemptEviction(true);
                    }
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                this.unlock();
                this.notifyEvictionListener(evicted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object replace(Object key, int hash, Object newValue) {
            this.lock();
            Set<HashEntry> evicted = null;
            try {
                HashEntry e = this.getFirst(hash);
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                Object oldValue = null;
                if (e != null) {
                    oldValue = e.value;
                    e.value = newValue;
                    if (this.eviction.onEntryHit(e)) {
                        evicted = this.attemptEviction(true);
                    }
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
                this.notifyEvictionListener(evicted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object put(Object key, int hash, Object value, boolean onlyIfAbsent) {
            this.lock();
            Set<HashEntry> evicted = null;
            try {
                Object oldValue;
                HashEntry first;
                int c = this.count;
                if (c++ > this.threshold && this.eviction.strategy() == Eviction.NONE) {
                    this.rehash();
                }
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value;
                        this.eviction.onEntryHit(e);
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    this.count = c;
                    if (this.eviction.strategy() != Eviction.NONE) {
                        if (c > this.evictCap) {
                            evicted = this.eviction.execute();
                            first = tab[index];
                        }
                        tab[index] = this.eviction.createNewEntry(key, hash, first, value);
                        Set<HashEntry> newlyEvicted = this.eviction.onEntryMiss(tab[index]);
                        if (!newlyEvicted.isEmpty()) {
                            if (evicted != null) {
                                evicted.addAll(newlyEvicted);
                            } else {
                                evicted = newlyEvicted;
                            }
                        }
                    } else {
                        tab[index] = this.eviction.createNewEntry(key, hash, first, value);
                    }
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
                this.notifyEvictionListener(evicted);
            }
        }

        void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashEntry e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = this.eviction.createNewEntry(p.key, p.hash, n, p.value);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object remove(Object key, int hash, Object value) {
            this.lock();
            try {
                HashEntry first;
                int c = this.count - 1;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                Object oldValue = null;
                if (e != null) {
                    Object v = e.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        this.eviction.onEntryRemove(e);
                        HashEntry newFirst = e.next;
                        HashEntry p = first;
                        while (p != e) {
                            this.eviction.onEntryRemove(p);
                            newFirst = this.eviction.createNewEntry(p.key, p.hash, newFirst, p.value);
                            this.eviction.onEntryMiss(newFirst);
                            p = p.next;
                        }
                        tab[index] = newFirst;
                        this.count = c;
                    }
                }
                Object object = oldValue;
                return object;
            }
            finally {
                this.unlock();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCount;
                    this.eviction.clear();
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<HashEntry> attemptEviction(boolean lockedAlready) {
            boolean obtainedLock;
            Set<HashEntry> evicted = null;
            boolean bl = obtainedLock = lockedAlready || this.tryLock();
            if (!obtainedLock && this.eviction.thresholdExpired()) {
                this.lock();
                obtainedLock = true;
            }
            if (obtainedLock) {
                try {
                    if (this.eviction.thresholdExpired()) {
                        evicted = this.eviction.execute();
                    }
                }
                finally {
                    if (!lockedAlready) {
                        this.unlock();
                    }
                }
            }
            return evicted;
        }

        private void notifyEvictionListener(Set<HashEntry> evicted) {
            if (evicted != null) {
                Map<Object, Object> evictedCopy;
                if (evicted.size() == 1) {
                    HashEntry evictedEntry = evicted.iterator().next();
                    evictedCopy = Collections.singletonMap(evictedEntry.key, evictedEntry.value);
                } else {
                    evictedCopy = new HashMap(evicted.size());
                    for (HashEntry he : evicted) {
                        evictedCopy.put(he.key, he.value);
                    }
                    evictedCopy = Collections.unmodifiableMap(evictedCopy);
                }
                this.evictionListener.onEntryEviction(evictedCopy);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LIRS
    implements EvictionPolicy {
        private static final float L_LIRS = 0.95f;
        private final Segment segment;
        private final ConcurrentLinkedQueue<LIRSHashEntry> accessQueue;
        private final int maxBatchQueueSize;
        private int size;
        private final float batchThresholdFactor;
        private final LIRSHashEntry header = new LIRSHashEntry(null, null, 0, null, null);
        private final int maximumHotSize;
        private final int maximumSize;
        private int hotSize;

        public LIRS(Segment s, int capacity, int maxBatchSize, float batchThresholdFactor) {
            this.segment = s;
            this.maximumSize = capacity;
            this.maximumHotSize = LIRS.calculateLIRSize(capacity);
            this.maxBatchQueueSize = maxBatchSize > 64 ? 64 : maxBatchSize;
            this.batchThresholdFactor = batchThresholdFactor;
            this.accessQueue = new ConcurrentLinkedQueue();
        }

        private static int calculateLIRSize(int maximumSize) {
            int result = (int)(0.95f * (float)maximumSize);
            return result == maximumSize ? maximumSize - 1 : result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<HashEntry> execute() {
            HashSet<HashEntry> evicted = new HashSet<HashEntry>();
            try {
                for (LIRSHashEntry e : this.accessQueue) {
                    if (!e.isResident()) continue;
                    e.hit(evicted);
                }
                this.removeFromSegment(evicted);
            }
            finally {
                this.accessQueue.clear();
            }
            return evicted;
        }

        private void pruneStack(Set<HashEntry> evicted) {
            LIRSHashEntry bottom = this.stackBottom();
            while (bottom != null && bottom.state != Recency.LIR_RESIDENT) {
                bottom.removeFromStack();
                if (bottom.state == Recency.HIR_NONRESIDENT) {
                    evicted.add(bottom);
                }
                bottom = this.stackBottom();
            }
        }

        @Override
        public Set<HashEntry> onEntryMiss(HashEntry en) {
            LIRSHashEntry e = (LIRSHashEntry)en;
            Set evicted = e.miss();
            this.removeFromSegment(evicted);
            return evicted;
        }

        private void removeFromSegment(Set<HashEntry> evicted) {
            for (HashEntry e : evicted) {
                ((LIRSHashEntry)e).evict();
                this.segment.evictionListener.onEntryChosenForEviction(e.value);
                this.segment.remove(e.key, e.hash, null);
            }
        }

        @Override
        public boolean onEntryHit(HashEntry e) {
            this.accessQueue.add((LIRSHashEntry)e);
            return (float)this.accessQueue.size() >= (float)this.maxBatchQueueSize * this.batchThresholdFactor;
        }

        @Override
        public boolean thresholdExpired() {
            return this.accessQueue.size() >= this.maxBatchQueueSize;
        }

        @Override
        public void onEntryRemove(HashEntry e) {
            ((LIRSHashEntry)e).remove();
            while (this.accessQueue.remove(e)) {
            }
        }

        @Override
        public void clear() {
            this.accessQueue.clear();
        }

        @Override
        public Eviction strategy() {
            return Eviction.LIRS;
        }

        private LIRSHashEntry stackBottom() {
            LIRSHashEntry bottom = this.header.previousInStack;
            return bottom == this.header ? null : bottom;
        }

        private LIRSHashEntry queueFront() {
            LIRSHashEntry front = this.header.nextInQueue;
            return front == this.header ? null : front;
        }

        private LIRSHashEntry queueEnd() {
            LIRSHashEntry end = this.header.previousInQueue;
            return end == this.header ? null : end;
        }

        @Override
        public HashEntry createNewEntry(Object key, int hash, HashEntry next, Object value) {
            return new LIRSHashEntry(this, key, hash, next, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LIRSHashEntry
    extends HashEntry {
        private LIRSHashEntry previousInStack;
        private LIRSHashEntry nextInStack;
        private LIRSHashEntry previousInQueue;
        private LIRSHashEntry nextInQueue;
        volatile Recency state;
        LIRS owner;

        LIRSHashEntry(LIRS owner, Object key, int hash, HashEntry next, Object value) {
            super(key, hash, next, value);
            this.owner = owner;
            this.state = Recency.HIR_RESIDENT;
            this.previousInStack = this;
            this.nextInStack = this;
            this.previousInQueue = this;
            this.nextInQueue = this;
        }

        @Override
        public int hashCode() {
            int result = 17;
            result = result * 31 + this.hash;
            result = result * 31 + this.key.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            HashEntry other = (HashEntry)o;
            return this.hash == other.hash && this.key.equals(other.key);
        }

        public boolean inStack() {
            return this.nextInStack != null;
        }

        public boolean inQueue() {
            return this.nextInQueue != null;
        }

        public void hit(Set<HashEntry> evicted) {
            switch (this.state) {
                case LIR_RESIDENT: {
                    this.hotHit(evicted);
                    break;
                }
                case HIR_RESIDENT: {
                    this.coldHit(evicted);
                    break;
                }
                case HIR_NONRESIDENT: {
                    throw new IllegalStateException("Can't hit a non-resident entry!");
                }
                default: {
                    throw new AssertionError((Object)("Hit with unknown status: " + (Object)((Object)this.state)));
                }
            }
        }

        private void hotHit(Set<HashEntry> evicted) {
            boolean onBottom = this.owner.stackBottom() == this;
            this.moveToStackTop();
            if (onBottom) {
                this.owner.pruneStack(evicted);
            }
        }

        private void coldHit(Set<HashEntry> evicted) {
            boolean inStack = this.inStack();
            this.moveToStackTop();
            if (inStack) {
                this.hot();
                this.removeFromQueue();
                this.owner.stackBottom().migrateToQueue();
                this.owner.pruneStack(evicted);
            } else {
                this.moveToQueueEnd();
            }
        }

        private Set<HashEntry> miss() {
            Set<HashEntry> evicted = Collections.emptySet();
            if (this.owner.hotSize < this.owner.maximumHotSize) {
                this.warmupMiss();
            } else {
                evicted = new HashSet();
                this.fullMiss(evicted);
            }
            this.owner.size++;
            return evicted;
        }

        private void warmupMiss() {
            this.hot();
            this.moveToStackTop();
        }

        private void fullMiss(Set<HashEntry> evicted) {
            if (this.owner.size >= this.owner.maximumSize) {
                LIRSHashEntry evictedNode = this.owner.queueFront();
                evicted.add(evictedNode);
            }
            boolean inStack = this.inStack();
            this.moveToStackTop();
            if (inStack) {
                this.hot();
                this.owner.stackBottom().migrateToQueue();
                this.owner.pruneStack(evicted);
            } else {
                this.cold();
            }
        }

        private void hot() {
            if (this.state != Recency.LIR_RESIDENT) {
                this.owner.hotSize++;
            }
            this.state = Recency.LIR_RESIDENT;
        }

        private void cold() {
            if (this.state == Recency.LIR_RESIDENT) {
                this.owner.hotSize--;
            }
            this.state = Recency.HIR_RESIDENT;
            this.moveToQueueEnd();
        }

        private void nonResident() {
            switch (this.state) {
                case LIR_RESIDENT: {
                    this.owner.hotSize--;
                }
                case HIR_RESIDENT: {
                    this.owner.size--;
                }
            }
            this.state = Recency.HIR_NONRESIDENT;
        }

        public boolean isResident() {
            return this.state != Recency.HIR_NONRESIDENT;
        }

        private void tempRemoveFromStack() {
            if (this.inStack()) {
                this.previousInStack.nextInStack = this.nextInStack;
                this.nextInStack.previousInStack = this.previousInStack;
            }
        }

        private void removeFromStack() {
            this.tempRemoveFromStack();
            this.previousInStack = null;
            this.nextInStack = null;
        }

        private void addToStackBefore(LIRSHashEntry existingEntry) {
            this.previousInStack = existingEntry.previousInStack;
            this.nextInStack = existingEntry;
            this.previousInStack.nextInStack = this;
            this.nextInStack.previousInStack = this;
        }

        private void moveToStackTop() {
            this.tempRemoveFromStack();
            this.addToStackBefore(((LIRS)this.owner).header.nextInStack);
        }

        private void moveToStackBottom() {
            this.tempRemoveFromStack();
            this.addToStackBefore(this.owner.header);
        }

        private void tempRemoveFromQueue() {
            if (this.inQueue()) {
                this.previousInQueue.nextInQueue = this.nextInQueue;
                this.nextInQueue.previousInQueue = this.previousInQueue;
            }
        }

        private void removeFromQueue() {
            this.tempRemoveFromQueue();
            this.previousInQueue = null;
            this.nextInQueue = null;
        }

        private void addToQueueBefore(LIRSHashEntry existingEntry) {
            this.previousInQueue = existingEntry.previousInQueue;
            this.nextInQueue = existingEntry;
            this.previousInQueue.nextInQueue = this;
            this.nextInQueue.previousInQueue = this;
        }

        private void moveToQueueEnd() {
            this.tempRemoveFromQueue();
            this.addToQueueBefore(this.owner.header);
        }

        private void migrateToQueue() {
            this.removeFromStack();
            this.cold();
        }

        private void migrateToStack() {
            this.removeFromQueue();
            if (!this.inStack()) {
                this.moveToStackBottom();
            }
            this.hot();
        }

        private void evict() {
            this.removeFromQueue();
            this.removeFromStack();
            this.nonResident();
            this.owner = null;
        }

        private Object remove() {
            boolean wasHot = this.state == Recency.LIR_RESIDENT;
            Object result = this.value;
            LIRSHashEntry end = this.owner != null ? this.owner.queueEnd() : null;
            this.evict();
            if (wasHot && end != null) {
                end.migrateToStack();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LRU
    extends LinkedHashMap<HashEntry, Object>
    implements EvictionPolicy {
        private static final long serialVersionUID = -7645068174197717838L;
        private final ConcurrentLinkedQueue<HashEntry> accessQueue;
        private final Segment segment;
        private final int maxBatchQueueSize;
        private final int trimDownSize;
        private final float batchThresholdFactor;
        private final Set<HashEntry> evicted;

        public LRU(Segment s, int capacity, float lf, int maxBatchSize, float batchThresholdFactor) {
            super(capacity, lf, true);
            this.segment = s;
            this.trimDownSize = capacity;
            this.maxBatchQueueSize = maxBatchSize > 64 ? 64 : maxBatchSize;
            this.batchThresholdFactor = batchThresholdFactor;
            this.accessQueue = new ConcurrentLinkedQueue();
            this.evicted = new HashSet<HashEntry>();
        }

        @Override
        public Set<HashEntry> execute() {
            HashSet<HashEntry> evictedCopy = new HashSet<HashEntry>();
            for (HashEntry e : this.accessQueue) {
                this.put(e, e.value);
            }
            evictedCopy.addAll(this.evicted);
            this.accessQueue.clear();
            this.evicted.clear();
            return evictedCopy;
        }

        @Override
        public Set<HashEntry> onEntryMiss(HashEntry e) {
            this.put(e, e.value);
            if (!this.evicted.isEmpty()) {
                HashSet<HashEntry> evictedCopy = new HashSet<HashEntry>();
                evictedCopy.addAll(this.evicted);
                this.evicted.clear();
                return evictedCopy;
            }
            return Collections.emptySet();
        }

        @Override
        public boolean onEntryHit(HashEntry e) {
            this.accessQueue.add(e);
            return (float)this.accessQueue.size() >= (float)this.maxBatchQueueSize * this.batchThresholdFactor;
        }

        @Override
        public boolean thresholdExpired() {
            return this.accessQueue.size() >= this.maxBatchQueueSize;
        }

        @Override
        public void onEntryRemove(HashEntry e) {
            this.remove(e);
            while (this.accessQueue.remove(e)) {
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.accessQueue.clear();
        }

        @Override
        public Eviction strategy() {
            return Eviction.LRU;
        }

        protected boolean isAboveThreshold() {
            return this.size() > this.trimDownSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<HashEntry, Object> eldest) {
            boolean aboveThreshold = this.isAboveThreshold();
            if (aboveThreshold) {
                HashEntry evictedEntry = eldest.getKey();
                this.segment.evictionListener.onEntryChosenForEviction(evictedEntry.value);
                this.segment.remove(evictedEntry.key, evictedEntry.hash, null);
                this.evicted.add(evictedEntry);
            }
            return aboveThreshold;
        }

        @Override
        public HashEntry createNewEntry(Object key, int hash, HashEntry next, Object value) {
            return new HashEntry(key, hash, next, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullEvictionPolicy
    implements EvictionPolicy {
        NullEvictionPolicy() {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<HashEntry> execute() {
            return Collections.emptySet();
        }

        @Override
        public boolean onEntryHit(HashEntry e) {
            return false;
        }

        @Override
        public Set<HashEntry> onEntryMiss(HashEntry e) {
            return Collections.emptySet();
        }

        @Override
        public void onEntryRemove(HashEntry e) {
        }

        @Override
        public boolean thresholdExpired() {
            return false;
        }

        @Override
        public Eviction strategy() {
            return Eviction.NONE;
        }

        @Override
        public HashEntry createNewEntry(Object key, int hash, HashEntry next, Object value) {
            return new HashEntry(key, hash, next, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EvictionPolicy {
        public static final int MAX_BATCH_SIZE = 64;

        public HashEntry createNewEntry(Object var1, int var2, HashEntry var3, Object var4);

        public Set<HashEntry> execute();

        public Set<HashEntry> onEntryMiss(HashEntry var1);

        public boolean onEntryHit(HashEntry var1);

        public void onEntryRemove(HashEntry var1);

        public void clear();

        public Eviction strategy();

        public boolean thresholdExpired();
    }

    static final class NullEvictionListener
    implements EvictionListener {
        NullEvictionListener() {
        }

        public void onEntryEviction(Map evicted) {
        }

        public void onEntryChosenForEviction(Object internalCacheEntry) {
        }
    }

    public static interface EvictionListener {
        public void onEntryEviction(Map var1);

        public void onEntryChosenForEviction(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Eviction {
        NONE{

            public EvictionPolicy make(Segment s, int capacity, float lf) {
                return new NullEvictionPolicy();
            }
        }
        ,
        LRU{

            public EvictionPolicy make(Segment s, int capacity, float lf) {
                return new LRU(s, capacity, lf, capacity * 10, lf);
            }
        }
        ,
        LIRS{

            public EvictionPolicy make(Segment s, int capacity, float lf) {
                return new LIRS(s, capacity, capacity * 10, lf);
            }
        };


        abstract EvictionPolicy make(Segment var1, int var2, float var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Recency {
        HIR_RESIDENT,
        LIR_RESIDENT,
        HIR_NONRESIDENT;

    }

    private static class HashEntry {
        final Object key;
        final int hash;
        volatile Object value;
        final HashEntry next;

        HashEntry(Object key, int hash, HashEntry next, Object value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + this.hash;
            result = result * 31 + this.key.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            HashEntry other = (HashEntry)o;
            return this.hash == other.hash && this.key.equals(other.key);
        }

        static HashEntry[] newArray(int i) {
            return new HashEntry[i];
        }
    }
}

