/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.engine;

import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.executor.SystemException;
import com.ygsoft.ecp.service.executor.engine.ExecutionCancelledException;
import com.ygsoft.ecp.service.executor.engine.ExecutionInterruptedException;
import com.ygsoft.ecp.service.executor.engine.ExecutionTimeoutException;
import com.ygsoft.ecp.service.executor.engine.PausableThreadPoolExecutor;
import com.ygsoft.ecp.service.executor.engine.ServiceContext;
import com.ygsoft.ecp.service.executor.engine.ServiceExecution;
import com.ygsoft.ecp.service.executor.engine.ServiceExecutor;
import com.ygsoft.ecp.service.executor.engine.ServiceHandler;
import com.ygsoft.ecp.service.executor.engine.TaskComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceExecutor
implements ServiceExecutor {
    private Log log = LogFactory.getLog(this.getClass());
    private PausableThreadPoolExecutor executor;
    private Map<Serializable, ServiceExecution> pendingExecutions = new ConcurrentHashMap<Serializable, ServiceExecution>(50);
    private int corePoolSize = 50;
    private int maximumPoolSize = 100;
    private long keepAliveTime = 3600L;
    private int defaultTimeout = 3600;

    public DefaultServiceExecutor() {
        this.executor = new PausableThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(this.maximumPoolSize, new TaskComparator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceMessage execute(ServiceMessage message, int newtimeout, ServiceHandler serviceHandler) throws Exception {
        int timeout = newtimeout;
        if (newtimeout <= 0) {
            timeout = this.defaultTimeout;
        }
        ServiceMessage result = null;
        Future<ServiceMessage> future = null;
        ServiceExecution serviceExecution = new ServiceExecution(message, serviceHandler, ServiceContext.getContext());
        try {
            if ("false".equals(message.getString("true"))) {
                this.executor.submit(serviceExecution);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"request execution thread is no block!");
                }
                ServiceMessage serviceMessage = message;
                return serviceMessage;
            }
            future = this.executor.submit(serviceExecution);
            serviceExecution.setFuture(future);
            this.pendingExecutions.put(Integer.valueOf(serviceExecution.getExecutionId()), serviceExecution);
            result = future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            result = this.processExecutionException(serviceExecution, e);
        }
        finally {
            this.pendingExecutions.remove(serviceExecution.getExecutionId());
        }
        return result;
    }

    @Override
    public void submit(ServiceMessage message, ServiceHandler serviceHandler) {
        ServiceExecution serviceExecution = new ServiceExecution(message, serviceHandler, ServiceContext.getContext());
        this.executor.submit(serviceExecution);
    }

    protected ServiceMessage processExecutionException(ServiceExecution serviceExecution, Throwable e) throws Exception {
        if (e instanceof ExecutionException) {
            this.log.error((Object)"Execution failed!", e);
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof SystemException) {
                throw (SystemException)cause;
            }
            throw new SystemException(cause);
        }
        if (e instanceof InterruptedException) {
            this.log.error((Object)"Request execution is interrupted!", e);
            throw new ExecutionInterruptedException(serviceExecution.getExecutionId(), e);
        }
        if (e instanceof TimeoutException) {
            this.log.error((Object)"Request execution timed out!", e);
            throw new ExecutionTimeoutException(serviceExecution.getExecutionId(), e);
        }
        if (e instanceof CancellationException) {
            this.log.error((Object)"Request execution is cancelled!", e);
            throw new ExecutionCancelledException(serviceExecution.getExecutionId(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceExecution> getPendingExecutions() {
        ArrayList<ServiceExecution> result = new ArrayList<ServiceExecution>(this.pendingExecutions.size());
        Map<Serializable, ServiceExecution> map = this.pendingExecutions;
        synchronized (map) {
            result.addAll(this.pendingExecutions.values());
        }
        return result;
    }

    @Override
    public boolean cancellExecution(int executionId) {
        boolean result = false;
        ServiceExecution serviceExecution = this.pendingExecutions.get(executionId);
        if (serviceExecution != null && (result = serviceExecution.cancel(false))) {
            this.pendingExecutions.remove(executionId);
        }
        return result;
    }

    public PausableThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(PausableThreadPoolExecutor newexecutor) {
        this.executor = newexecutor;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int newcorePoolSize) {
        this.corePoolSize = newcorePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int newmaximumPoolSize) {
        this.maximumPoolSize = newmaximumPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long newkeepAliveTime) {
        this.keepAliveTime = newkeepAliveTime;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(int newdefaultTimeout) {
        this.defaultTimeout = newdefaultTimeout;
    }
}

