/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.engine;

import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.datasource.DataSourceSwapper;
import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.LogContextHolder;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;

public final class SessionServiceFilter {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SessionServiceFilter.class);
    private static final String DATACONTEXT_KEY = "DATACONTEXT_KEY";
    private static final String LOGCONTEXT_KEY = "LOGCONTEXT_KEY";
    private static final String TOKEN_KEY = "TOKEN_KEY";
    public static final String GAP_FLAG = "GAP_FLAG";
    public static final String GAP_TYPE = "GAP";
    public static final String ECP_TYPE = "ECP";
    public static final String SESSION_FILTER_FLAG = "SESSION_FILTER_FLAG";
    private static Object dataContentService = null;

    public static boolean isGap() {
        return false;
    }

    public static void buildSessionAndDataBus(ServiceMessage message) {
        String type;
        boolean isGap = GAP_TYPE.equals(message.get(GAP_FLAG));
        String string = type = isGap ? GAP_TYPE : ECP_TYPE;
        if (LOG.isDebugEnabled()) {
            LOG.info(type + "-->>\u6d88\u606f\u4f53\u52a0\u5165\u603b\u7ebf\u548c\u4f1a\u8bdd\u4fe1\u606f\u5f00\u59cb,\u7ebf\u7a0b\uff1a" + Thread.currentThread().getId());
        }
        message.set(LOGCONTEXT_KEY, LogContextHolder.INSTANCE.getLogContext());
        message.set(TOKEN_KEY, TokenHolder.INSTANCE.getToken());
        Object dataContext = ClassUtil.callMethod(SessionServiceFilter.getDataContent(), "getCurrentDataContext", null);
        message.set(DATACONTEXT_KEY, dataContext);
        if (LOG.isDebugEnabled()) {
            LOG.info(type + "-->>\u6d88\u606f\u4f53\u52a0\u5165\u603b\u7ebf\u548c\u4f1a\u8bdd\u7ed3\u675f,\u7ebf\u7a0b\uff1a" + Thread.currentThread().getId());
        }
    }

    static void createSessionAndDataBus(ServiceMessage message) {
        String type;
        boolean isGap = GAP_TYPE.equals(message.get(GAP_FLAG));
        String string = type = isGap ? GAP_TYPE : ECP_TYPE;
        if (LOG.isDebugEnabled()) {
            LOG.debug(type + "-->>\u521b\u5efa\u603b\u7ebf\u548c\u4f1a\u8bdd\u6570\u636e\u5f00\u59cb,\u7ebf\u7a0b\uff1a" + Thread.currentThread().getId());
        }
        LogContextHolder.INSTANCE.setLogContext((LogContextHolder.ILogContext)message.get(LOGCONTEXT_KEY));
        TokenHolder.INSTANCE.setToken(String.valueOf(message.get(TOKEN_KEY)));
        Object dataContext = message.get(DATACONTEXT_KEY);
        ClassUtil.callMethod(SessionServiceFilter.getDataContent(), "setCurrentDataContext", new Object[]{null, dataContext});
        Object jndi = message.get("jndi-ds");
        if (jndi != null) {
            DataSourceSwapper.INSTANCE.set(jndi.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(type + "-->>\u521b\u5efa\u603b\u7ebf\u548c\u4f1a\u8bdd\u6570\u636e\u7ed3\u675f,\u7ebf\u7a0b\uff1a" + Thread.currentThread().getId());
        }
    }

    static void clearSessionAndDataBus(ServiceMessage message) {
        String type;
        boolean isGap = GAP_TYPE.equals(message.get(GAP_FLAG));
        String string = type = isGap ? GAP_TYPE : ECP_TYPE;
        if (LOG.isInfoEnabled()) {
            LOG.info(type + "-->>\u6e05\u9664\u603b\u7ebf\u548c\u4f1a\u8bdd\u6570\u636e\u5f00\u59cb,\u7ebf\u7a0b\uff1a" + Thread.currentThread().getId());
        }
        LogContextHolder.INSTANCE.clearLogContext();
        TokenHolder.INSTANCE.clearToken();
        ClassUtil.callMethod(SessionServiceFilter.getDataContent(), "clearCurrentDataContext", null);
        if (DataSourceSwapper.INSTANCE.get() != null) {
            DataSourceSwapper.INSTANCE.set(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(type + "-->>\u6e05\u9664\u603b\u7ebf\u548c\u4f1a\u8bdd\u6570\u636e\u7ed3\u675f,\u7ebf\u7a0b\uff1a" + Thread.currentThread().getId());
        }
    }

    private static Object getDataContent() {
        if (dataContentService == null) {
            dataContentService = OSGiUtil.getSpringBean("ecpDataContextService");
        }
        return dataContentService;
    }
}

