/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.engine;

import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.executor.SystemException;
import com.ygsoft.ecp.service.executor.engine.ServiceExecution;
import com.ygsoft.ecp.service.executor.engine.ServiceExecutor;
import com.ygsoft.ecp.service.executor.engine.ServiceHandler;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleServiceExecutor
implements ServiceExecutor {
    private Log log = LogFactory.getLog(this.getClass());

    @Override
    public ServiceMessage execute(ServiceMessage message, int newtimeout, ServiceHandler serviceHandler) throws Exception {
        return serviceHandler.service(message);
    }

    @Override
    public void submit(ServiceMessage message, ServiceHandler serviceHandler) {
        try {
            serviceHandler.service(message);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Execution failed!", (Throwable)e);
            }
            throw new SystemException(e);
        }
    }

    @Override
    public List<ServiceExecution> getPendingExecutions() {
        return Collections.emptyList();
    }

    @Override
    public boolean cancellExecution(int executionId) {
        return true;
    }
}

