/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.filter;

import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.executor.filter.AfterFilter;
import com.ygsoft.ecp.service.executor.filter.AroundFilter;
import com.ygsoft.ecp.service.executor.filter.BeforeFilter;
import com.ygsoft.ecp.service.tool.ClassUtil;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    private Class<?> clasz;
    private BeforeFilter beforeFilter;
    private AfterFilter afterFilter;
    private AroundFilter aroundFilter;
    public static final String DEFAULT_BEFORE = "before";
    public static final String DEFAULT_AFTER = "after";
    private static final Map<String, String> shortService = new HashMap<String, String>();
    static final String DATASOURCE_INVOKE = "masterSlaveSwitch";
    static final String DATASOURCE_INVOKE_CLASS = "com.ygsoft.ecp.service.datasource.DataSourceInvoker";
    static final String METHOD_INVOKE = "methodInvokeCache";
    static final String METHOD_INVOKE_CLASS = "com.ygsoft.ecp.service.executor.cache.MethodCacheInvoker";

    public Filter(Class<?> newclasz, BeforeFilter newbeforeFilter) {
        this.clasz = newclasz;
        this.beforeFilter = newbeforeFilter;
    }

    public Filter(Class<?> newclasz, AfterFilter newafterFilter) {
        this.clasz = newclasz;
        this.afterFilter = newafterFilter;
    }

    public Filter(Class<?> newclasz, AroundFilter newaroundFilter) {
        this.clasz = newclasz;
        this.aroundFilter = newaroundFilter;
    }

    public boolean canInvoke(String actionName) {
        String[] only = new String[]{};
        String[] except = new String[]{};
        if (this.beforeFilter != null) {
            only = this.beforeFilter.only();
            except = this.beforeFilter.except();
        } else if (this.afterFilter != null) {
            only = this.afterFilter.only();
            except = this.afterFilter.except();
        } else if (this.aroundFilter != null) {
            only = this.aroundFilter.only();
            except = this.aroundFilter.except();
        }
        return only.length == 0 && except.length == 0 || only.length > 0 && this.isContains(only, actionName) || except.length > 0 && !this.isContains(except, actionName);
    }

    public boolean beforeInvoke(ServiceMessage message) throws Exception {
        if (this.beforeFilter != null) {
            String service = this.beforeFilter.service();
            if (this.clasz.getName().equalsIgnoreCase(this.getInvoker(service))) {
                return true;
            }
            String action = this.beforeFilter.action();
            Object result = this.invoke(message, service, action);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        } else if (this.aroundFilter != null) {
            String service = this.aroundFilter.service();
            if (this.clasz.getName().equalsIgnoreCase(this.getInvoker(service))) {
                return true;
            }
            String action = this.aroundFilter.before();
            Object result = this.invoke(message, service, action);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        return true;
    }

    private Object invoke(ServiceMessage message, String service, String action) {
        String[] s;
        String className = service;
        if (service.indexOf("#") > 0 && (s = service.split("#")).length == 2 && (DATASOURCE_INVOKE.equals(s[0]) || DATASOURCE_INVOKE_CLASS.equals(s[0]))) {
            className = DATASOURCE_INVOKE;
            message.set("jndi-ds", s[1]);
        }
        Object instance = ClassUtil.createObject(this.getInvoker(className));
        Object result = ClassUtil.callMethod(instance, action, new Object[]{message});
        return result;
    }

    public boolean afterInvoke(ServiceMessage message) throws Exception {
        if (this.afterFilter != null) {
            String service = this.afterFilter.service();
            if (this.clasz.getName().equalsIgnoreCase(this.getInvoker(service))) {
                return true;
            }
            String action = this.afterFilter.action();
            Object result = this.invoke(message, service, action);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        } else if (this.aroundFilter != null) {
            String service = this.aroundFilter.service();
            if (this.clasz.getName().equalsIgnoreCase(this.getInvoker(service))) {
                return true;
            }
            String action = this.aroundFilter.after();
            Object result = this.invoke(message, service, action);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        return true;
    }

    private String getInvoker(String service) {
        if (shortService.containsKey(service)) {
            return shortService.get(service);
        }
        return service;
    }

    private boolean isContains(String[] items, String item) {
        if (items == null) {
            return false;
        }
        for (String s : items) {
            if (!s.equals(item)) continue;
            return true;
        }
        return false;
    }

    public BeforeFilter getBeforeFilter() {
        return this.beforeFilter;
    }

    public AfterFilter getAfterFilter() {
        return this.afterFilter;
    }

    public AroundFilter getAroundFilter() {
        return this.aroundFilter;
    }

    static {
        shortService.put(METHOD_INVOKE, METHOD_INVOKE_CLASS);
        shortService.put(DATASOURCE_INVOKE, DATASOURCE_INVOKE_CLASS);
    }
}

