/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.log;

import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.log.LogContextHolder;
import com.ygsoft.ecp.service.log.ServiceMonitor;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import com.ygsoft.ecp.service.tool.XtcsUtil;

public final class LogStoreBuilder {
    private static final int MAX_SIZE = 3500;

    private LogStoreBuilder() {
    }

    public static ServiceMonitor build(ServiceMessage message) {
        boolean flag;
        String sid = message.getString("SERVICE_EXECUTE_ID");
        boolean bl = flag = sid != null || XtcsUtil.isMonitorLogAccess();
        if (flag) {
            String exception;
            ServiceMonitor monitor = new ServiceMonitor();
            Long stime = message.getLong("ST_TIME");
            monitor.setId(UuidUtil.newUUID());
            monitor.setSid(sid);
            monitor.setStart(stime);
            monitor.setEnd(System.currentTimeMillis());
            LogContextHolder.ILogContext logContext = LogContextHolder.INSTANCE.getLogContext();
            if (logContext != null) {
                monitor.setIp(logContext.getIp());
                monitor.setUname(logContext.getUserName());
            }
            int paramSize = message.getParameters() == null ? 0 : message.getParameters().length;
            String sname = message.getServiceCode() + "#" + message.getServiceName() + "#" + paramSize;
            monitor.setSname(sname);
            if (XtcsUtil.isMonitorInputOutput()) {
                try {
                    String result = JSONUtil.toJsonString(message.getContent());
                    monitor.setOutput(result != null ? (long)result.length() : 0L);
                    String params = JSONUtil.toJsonString(message.getParameters());
                    monitor.setInput(params != null ? (long)params.length() : 0L);
                }
                catch (Throwable result) {
                    // empty catch block
                }
            }
            if ((exception = message.getResultMsg()) != null && exception.length() > 3500) {
                monitor.setException(exception.substring(0, 3500));
            }
            monitor.setException(exception);
            return monitor;
        }
        return null;
    }
}

