/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.async;

import com.ygsoft.ecp.service.async.IAsynHandler;
import com.ygsoft.ecp.service.async.IAsyncResult;
import com.ygsoft.ecp.service.async.IPortableResult;
import com.ygsoft.ecp.service.exception.EcpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncResult<T>
implements IAsyncResult<T> {
    private IAsynHandler handler;

    public AsyncResult(IAsynHandler newHandle) {
        this.handler = newHandle;
    }

    @Override
    public T getResult() throws EcpException {
        try {
            IPortableResult result = (IPortableResult)this.handler.getObject();
            if (result != null) {
                return (T)result.value();
            }
            return null;
        }
        catch (Exception e) {
            throw new EcpException("result_error", e);
        }
    }

    @Override
    public T getResult(long timeout) throws EcpException {
        try {
            IPortableResult result = (IPortableResult)this.handler.getObject(timeout);
            if (result != null) {
                return (T)result.value();
            }
            return null;
        }
        catch (Exception e) {
            throw new EcpException("result_error", e);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.handler.isCompleted();
    }
}

