/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.config;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.AppOperatorSystemType;
import com.ygsoft.ecp.service.config.AppServerType;
import com.ygsoft.ecp.service.config.INodeConfig;
import java.io.File;

public class NodeConfig
implements INodeConfig {
    private AppServerType serverType = AppServerType.Weblogic;
    private String ipAddress;
    private int port;
    private String topic;
    private AppOperatorSystemType operatorSystemType = File.separatorChar == '\\' ? AppOperatorSystemType.Windows : AppOperatorSystemType.Linux;
    private String storageRootPath;

    public AppServerType getServerType() {
        return this.serverType;
    }

    public void setServerType(AppServerType newserverType) {
        this.serverType = newserverType;
    }

    public AppOperatorSystemType getOperatorSystemType() {
        return this.operatorSystemType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setIpAddress(String newipAddress) {
        this.ipAddress = newipAddress;
    }

    public void setPort(int newport) {
        this.port = newport;
    }

    public void setTopic(String newtopic) {
        this.topic = newtopic;
    }

    public void setOperatorSystemType(AppOperatorSystemType newoperatorSystemType) {
        this.operatorSystemType = newoperatorSystemType;
    }

    private String getPathEnv() {
        String pathprop = System.getProperty("ygsoft.ecp.storage.path");
        if (pathprop == null) {
            pathprop = System.getProperty("ygfmis.config.path");
        }
        String result = "";
        if (pathprop != null) {
            result = pathprop;
            if (result.endsWith(File.separator)) {
                result = result.substring(0, result.length() - 1);
            }
        } else {
            AppOperatorSystemType oType = EcpService.getConfigService().getNodeConfig().getOperatorSystemType();
            result = AppOperatorSystemType.Windows == oType ? "C:" : "/etc";
        }
        return result;
    }

    public String getStorageRootPath() {
        if (this.storageRootPath == null) {
            this.storageRootPath = this.getPathEnv();
        }
        return this.storageRootPath;
    }

    public void setStorageRootPath(String newstorageRootPath) {
        this.storageRootPath = newstorageRootPath;
    }
}

