/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.i18n;

import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.i18n.I18nResourceService;
import com.ygsoft.ecp.service.internal.i18n.DBResourceAccessService;
import com.ygsoft.ecp.service.internal.i18n.ResourceAccessService;
import com.ygsoft.ecp.service.model.IValueObject;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nResourceServiceImpl
implements I18nResourceService {
    public I18nResourceServiceImpl(BundleContext curBundleContext, ClassLoader curClsLoader) {
    }

    @Override
    public String getExceptionResourceMessage(String key) {
        Locale locale = EcpI18nUtil.getLoginLocale();
        return ResourceAccessService.getResource(locale, key);
    }

    @Override
    public String getI18nResourceMessage(String key) {
        Locale locale = EcpI18nUtil.getLoginLocale();
        return ResourceAccessService.getResource(locale, key);
    }

    @Override
    public String getExceptionResourceMessage(String key, Object ... parameters) {
        return this.getI18nResourceMessage(key, parameters);
    }

    @Override
    public String getI18nResourceMessage(String key, Object ... parameters) {
        Locale locale = EcpI18nUtil.getLoginLocale();
        String message = ResourceAccessService.getResource(locale, key);
        if (!StringUtils.isEmpty((CharSequence)message)) {
            return MessageFormat.format(message, parameters);
        }
        return key;
    }

    @Override
    public String getI18nResourceMessageBatch(String template) {
        Locale locale = EcpI18nUtil.getLoginLocale();
        String message = ResourceAccessService.getResourceBatch(locale, template);
        return message;
    }

    @Override
    public <V extends IValueObject> V getResourceMessage(V dataModel, String uri) {
        Locale locale = EcpI18nUtil.getLoginLocale();
        return ResourceAccessService.getResourceMessage(locale, dataModel, uri);
    }

    @Override
    public boolean deleteLocalizedString(String schema, Locale locale, String chName) {
        return DBResourceAccessService.deleteLocalizedString(schema, locale, chName);
    }

    @Override
    public boolean insertLocalizedString(String schema, Locale locale, String chName, String translatedStr) {
        return DBResourceAccessService.insertLocalizedString(schema, locale, chName, translatedStr);
    }

    @Override
    public String localizedStringByDB(String schema, Locale locale, String chName) {
        return DBResourceAccessService.localizedString(schema, locale, chName);
    }

    @Override
    public boolean updateLocalizedString(String schema, Locale locale, String chName, String translatedStr) {
        return DBResourceAccessService.updateLocalizedString(schema, locale, chName, translatedStr);
    }

    @Override
    public List<String> localizedStringByDB(String schema, Locale locale, List<String> chNames) {
        return DBResourceAccessService.localizedString(schema, locale, chNames);
    }

    @Override
    public <V extends IValueObject> V getResourceMessage(Locale locale, V dataModel, String uri) {
        if (locale == null) {
            Locale loginLocale = EcpI18nUtil.getLoginLocale();
            return ResourceAccessService.getResourceMessage(loginLocale, dataModel, uri);
        }
        return ResourceAccessService.getResourceMessage(locale, dataModel, uri);
    }

    @Override
    public boolean existsLocalizedString(String schema, Locale locale, String chName) {
        return DBResourceAccessService.existsLocalizedString(schema, locale, chName);
    }

    @Override
    public Map<String, Map<String, Object>> getResMap() {
        return ResourceAccessService.getResMap();
    }

    @Override
    public Map<String, Map<String, Object>> getResConfigMap() {
        return ResourceAccessService.getResConfigMap();
    }

    @Override
    public ICache<String, String> getDBResourceCache() {
        return DBResourceAccessService.getResourceCache();
    }

    @Override
    public int getLangIdByCode(String code) {
        return DBResourceAccessService.getLangIdByCode(code);
    }

    @Override
    public Map<String, String> localizedListStringByDB(String schema, Locale locale, List<String> chNames) {
        return DBResourceAccessService.localizedListString(schema, locale, chNames);
    }

    @Override
    public Map<String, String> transRuntimeFnames(String schema, Locale locale, List<String> chNames) {
        return DBResourceAccessService.transLanguageFnames(schema, locale, chNames, false);
    }

    @Override
    public Map<String, String> transDesignFnames(String schema, Locale locale, List<String> chNames) {
        return DBResourceAccessService.transLanguageFnames(schema, locale, chNames, true);
    }

    @Override
    public Map<String, Boolean> checkDicFnamesCount(String schema, List<String> chNames) {
        return DBResourceAccessService.checkDicFnamesCount(schema, chNames);
    }

    @Override
    public void pushRuntimeLanCache(Locale locale, Map<String, String> cacheMap) {
        DBResourceAccessService.pushLanCache(locale, cacheMap, false);
    }

    @Override
    public void pushDesignLanCache(Locale locale, Map<String, String> cacheMap) {
        DBResourceAccessService.pushLanCache(locale, cacheMap, true);
    }

    @Override
    public void resetLanguageCache() {
        DBResourceAccessService.initLanguageCache();
    }

    @Override
    public void cleanMutilingualCache() {
        DBResourceAccessService.cleanMutilingualCache();
    }

    @Override
    public Integer getLanIdByCode(Locale locale) {
        return DBResourceAccessService.getLanIdByCode(locale);
    }
}

