/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log;

import com.ygsoft.ecp.service.log.IEcpAccessLog;
import com.ygsoft.ecp.service.log.LogContextHolder;
import org.slf4j.Logger;

public class EcpAccessLogImpl
implements IEcpAccessLog {
    Logger logger = null;
    private static int logSize = 0;
    private static final int DEFAULTSIZE = 10240;
    private static final String ECPLOGSIZE = "ecp.log.length";
    private static final String SPERATOR = "|";

    public Logger getLog() {
        return this.logger;
    }

    public void setLog(Logger newlog) {
        this.logger = newlog;
    }

    public boolean isDebugEnable() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            try {
                this.logger.info(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            try {
                this.logger.info(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            try {
                this.logger.warn(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            try {
                this.logger.warn(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            try {
                this.logger.error(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            try {
                this.logger.error(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String getMessage(String value) {
        int length;
        int logLength;
        String message = " ";
        if (null != value) {
            message = value;
        }
        if ((logLength = this.getLogSize()) < (length = message.length())) {
            length = logLength;
        }
        message = message.substring(0, length);
        String gid = LogContextHolder.INSTANCE.getUniqueKey();
        if (gid == null) {
            return message;
        }
        return gid + SPERATOR + message;
    }

    private int getLogSize() {
        if (logSize == 0) {
            String size = System.getProperty(ECPLOGSIZE);
            try {
                logSize = size == null ? 10240 : Integer.parseInt(size);
            }
            catch (Exception e) {
                logSize = 10240;
            }
        }
        return logSize;
    }

    private String getMessage(String[] value) {
        if (value != null && value.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String str : value) {
                sb.append(str);
                sb.append(SPERATOR);
            }
            String msg = sb.substring(0, sb.length() - 1);
            return this.getMessage(msg);
        }
        return "";
    }

    public void debug(String message) {
        if (this.isDebugEnable()) {
            try {
                this.logger.debug(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnable()) {
            try {
                this.logger.debug(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void debug(String[] newObj) {
        if (this.isDebugEnable()) {
            try {
                this.logger.debug(this.getMessage(newObj));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void debug(String[] newObj, Throwable newThrowable) {
        if (this.isDebugEnable()) {
            try {
                this.logger.debug(this.getMessage(newObj), newThrowable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            try {
                this.logger.trace(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            try {
                this.logger.trace(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trace(String[] newObj) {
        if (this.isTraceEnabled()) {
            try {
                this.logger.trace(this.getMessage(newObj));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trace(String[] newObj, Throwable newThrowable) {
        if (this.isTraceEnabled()) {
            try {
                this.logger.trace(this.getMessage(newObj), newThrowable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void info(String[] newObj) {
        if (this.isInfoEnabled()) {
            try {
                this.logger.info(this.getMessage(newObj));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void info(String[] newObj, Throwable newThrowable) {
        if (this.isInfoEnabled()) {
            try {
                this.logger.info(this.getMessage(newObj), newThrowable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void warn(String[] newObj) {
        if (this.isWarnEnabled()) {
            try {
                this.logger.warn(this.getMessage(newObj));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void warn(String[] newObj, Throwable newThrowable) {
        if (this.isWarnEnabled()) {
            try {
                this.logger.warn(this.getMessage(newObj), newThrowable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void error(String[] newObj) {
        if (this.isErrorEnabled()) {
            try {
                this.logger.error(this.getMessage(newObj));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void error(String[] newObj, Throwable newThrowable) {
        if (this.isErrorEnabled()) {
            try {
                this.logger.error(this.getMessage(newObj), newThrowable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

