/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.log;

import com.ygsoft.ecp.service.internal.log.EcpBizLogImpl;
import com.ygsoft.ecp.service.log.IEcpBizLog;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.LogContextHolder;
import com.ygsoft.ecp.service.log.LogThreadUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class EcpLogImpl
implements IEcpLog {
    Logger log = null;
    IEcpBizLog bizLog = null;
    private static int logSize = 0;
    private static final int DEFAULTSIZE = 10240;
    private static final String ECPLOGSIZE = "ecp.log.length";
    private ThreadLocal<List<Long>> timeList = new ThreadLocal<List<Long>>(){

        @Override
        protected List<Long> initialValue() {
            return new ArrayList<Long>();
        }
    };

    public EcpLogImpl(String clsName) {
        this.bizLog = new EcpBizLogImpl(this, clsName);
    }

    public EcpLogImpl() {
        this.bizLog = new EcpBizLogImpl(this, null);
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger newlog) {
        this.log = newlog;
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return false;
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void trace(Object message) {
        if (this.log.isTraceEnabled()) {
            try {
                this.log.trace(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.log.isTraceEnabled()) {
            try {
                this.log.trace(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void debug(Object message) {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void info(Object message) {
        if (this.log.isInfoEnabled()) {
            try {
                this.log.info(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void info(Object message, Throwable t) {
        if (this.log.isInfoEnabled()) {
            try {
                this.log.info(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void warn(Object message) {
        if (this.log.isWarnEnabled()) {
            try {
                this.log.warn(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.log.isWarnEnabled()) {
            try {
                this.log.warn(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void error(Object message) {
        if (this.log.isErrorEnabled()) {
            try {
                this.log.error(this.getMessage(message));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void error(Object message, Throwable t) {
        if (this.log.isErrorEnabled()) {
            try {
                this.log.error(this.getMessage(message), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void fatal(Object message) {
    }

    public void fatal(Object message, Throwable t) {
    }

    public boolean isMarkTimeEnabled() {
        String markTime = System.getProperty("ECP.LOG.MARKTIME");
        boolean retVal = false;
        if (StringUtil.isNotEmptyString(markTime) && (markTime.equalsIgnoreCase("true") || markTime.equalsIgnoreCase("false"))) {
            retVal = Boolean.valueOf(markTime);
        }
        return retVal;
    }

    public void start(Object message) {
        this.info(message);
        List<Long> times = this.timeList.get();
        if (times.size() > 9999) {
            this.timeList.get().clear();
        }
        this.timeList.get().add(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Object message) {
        block4: {
            List<Long> times = this.timeList.get();
            try {
                long tc;
                long startMill = tc = System.currentTimeMillis();
                if (times.size() > 0) {
                    startMill = times.get(times.size() - 1);
                }
                this.info(message);
                this.info(new StringBuffer().append("\u6b64\u6b21\u64cd\u4f5c\u6240\u7528\u65f6\u4e3a\uff1a").append(tc -= startMill).append("\u6beb\u79d2").toString());
                Object var8_5 = null;
                if (times == null || times.size() <= 0) break block4;
                times.remove(times.size() - 1);
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (times != null && times.size() > 0) {
                    times.remove(times.size() - 1);
                }
                throw throwable;
            }
            {
            }
        }
    }

    public long getEndTime() {
        long tc = System.currentTimeMillis();
        List<Long> times = this.timeList.get();
        long startMill = tc;
        if (times.size() > 0) {
            startMill = times.get(times.size() - 1);
        }
        return tc -= startMill;
    }

    public void bizStart(String newBizName, String[] newParamNames, Object ... newArgs) {
        this.bizLog.bizStart(newBizName, newParamNames, newArgs);
    }

    public void bizEnd(String newBizName, Object newResult) {
        this.bizLog.bizEnd(newBizName, newResult);
    }

    public void bizLog(String newMessage, Object ... newArgs) {
        this.bizLog.bizLog(newMessage, newArgs);
    }

    public boolean isBizLogEnabled() {
        return this.bizLog.isBizLogEnabled();
    }

    public void info(String newMessage, long time) {
        String layerCode = LogThreadUtil.evalLayerCode();
        StringBuilder sb = new StringBuilder(String.valueOf(time));
        sb.append("^");
        sb.append("L");
        sb.append("^");
        sb.append(layerCode);
        sb.append("^");
        sb.append(newMessage);
        this.info(sb.toString());
    }

    public void info(String newMessage, long time, String type) {
        String layerCode = LogThreadUtil.evalLayerCode();
        StringBuilder sb = new StringBuilder(String.valueOf(time));
        sb.append("^");
        sb.append(type);
        sb.append("^");
        sb.append(layerCode);
        sb.append("^");
        sb.append(newMessage);
        this.info(sb.toString());
    }

    private String getMessage(Object value) {
        String message = value == null ? " " : value.toString();
        int logSize = this.getLogSize();
        int length = message.length();
        length = logSize < length ? logSize : length;
        message = message.substring(0, length);
        String gid = LogContextHolder.INSTANCE.getUniqueKey();
        if (gid == null) {
            return message;
        }
        return gid + "|" + message;
    }

    private int getLogSize() {
        if (logSize == 0) {
            String size = System.getProperty(ECPLOGSIZE);
            try {
                logSize = size == null ? 10240 : Integer.parseInt(size);
            }
            catch (Exception e) {
                logSize = 10240;
            }
        }
        return logSize;
    }
}

