/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.storage;

import com.ygsoft.ecp.service.internal.storage.StorageUtil;
import com.ygsoft.ecp.service.storage.IFileStorage;
import com.ygsoft.ecp.service.storage.StorageWriteModel;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class CommonFileStorage
implements IFileStorage {
    private String rootPath;
    private static final String COMMON_PATH = "common";

    public CommonFileStorage(String newrootPath) {
        this.rootPath = StorageUtil.comboPath(newrootPath, COMMON_PATH);
    }

    public CommonFileStorage(String newrootPath, String curPath) {
        this.rootPath = StorageUtil.comboPath(newrootPath, curPath);
    }

    public boolean isFileExists(String path) {
        File file = new File(StorageUtil.comboPath(this.rootPath, path));
        return file.exists();
    }

    public boolean deleteFile(String path) {
        File file = new File(StorageUtil.comboPath(this.rootPath, path));
        return file.delete();
    }

    public byte[] read(String path) throws IOException {
        File file = new File(StorageUtil.comboPath(this.rootPath, path));
        if (!file.exists()) {
            return null;
        }
        return StreamUtil.getBytes(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(String path, byte[] content, StorageWriteModel model) throws IOException {
        File file = new File(StorageUtil.comboPath(this.rootPath, path));
        if (!file.exists()) {
            StorageUtil.createPathFile(file);
        }
        FileOutputStream stream = new FileOutputStream(file);
        try {
            stream.write(content);
        }
        finally {
            StreamUtil.closeStream(stream);
        }
        return content.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(String path, byte[] content, int off, int len, StorageWriteModel model) throws IOException {
        File file = new File(StorageUtil.comboPath(this.rootPath, path));
        if (!file.exists()) {
            StorageUtil.createPathFile(file);
        }
        FileOutputStream stream = new FileOutputStream(file);
        try {
            stream.write(content, off, len);
        }
        finally {
            StreamUtil.closeStream(stream);
        }
        return content.length;
    }
}

