/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.storage;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.exception.NotSupportException;
import com.ygsoft.ecp.service.internal.storage.CommonFileStorage;
import com.ygsoft.ecp.service.internal.storage.DBStorage;
import com.ygsoft.ecp.service.storage.IDBStorage;
import com.ygsoft.ecp.service.storage.IFileStorage;
import com.ygsoft.ecp.service.storage.IOSGiUnStructureStorage;
import com.ygsoft.ecp.service.storage.IStorageService;
import com.ygsoft.ecp.service.storage.IUnStructureStorage;
import com.ygsoft.ecp.service.tool.OSGiUtil;

public class StorageService
implements IStorageService {
    public static final StorageService INSTANCE = new StorageService();

    public IFileStorage getCommonFileStorage() {
        return new CommonFileStorage(EcpService.getConfigService().getApplicationConfig().getAbsoluteStoragePath());
    }

    public IFileStorage getTempFileStorage() {
        return new CommonFileStorage(EcpService.getConfigService().getApplicationConfig().getAbsoluteStoragePath(), "temp");
    }

    public IFileStorage getDynamicWebFileStorage() {
        throw new NotSupportException();
    }

    public IDBStorage getDBStorage() {
        return new DBStorage();
    }

    public IUnStructureStorage getUnStructureStorage() {
        return OSGiUtil.getService(IUnStructureStorage.class);
    }

    public IOSGiUnStructureStorage getOSGiUnStructureStorage() {
        return OSGiUtil.getService(IOSGiUnStructureStorage.class);
    }
}

