/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.tool;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ygsoft.ecp.framework.model.dynamic.IDynamicModel;
import com.ygsoft.ecp.framework.rest.IController;
import com.ygsoft.ecp.service.internal.tool.HTTPServiceRequester;
import com.ygsoft.ecp.service.internal.tool.RestServiceRequester;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.SysPropUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPServiceProxy
implements InvocationHandler {
    private Object deledate;
    private String remoteHost;
    private Class<?> interfaceClass;
    private Log logger;
    private static final Log LOG = LogFactory.getLog(HTTPServiceRequester.class);
    private static final String YGSOFT_PACKAGE = "com.ygsoft.";
    public static final String MAPP_MONOLITH_IP = "mapp.monolith.ip";
    public static final String MAPP_MONOLITH_PORT = "mapp.monolith.port";
    public static final String MAPP_MONOLITH_ADDRESS = "mapp.monolith.address";
    public static final String MAPP_MONOLITH_VIPADDRESS = System.getProperty("mapp.myvipaddress") == null ? "monolith" : System.getProperty("mapp.myvipaddress");
    public static final String MAPP_CLIENT_CLASS = "com.ygsoft.ecp.core.mapp.util.AddressUtil";
    private static final Set<String> SET = new HashSet<String>();

    public HTTPServiceProxy(String host) {
        this.remoteHost = host;
    }

    public <T> T bind(Object newdeledate, Class<T> newinterfaceClass) {
        this.deledate = newdeledate;
        this.interfaceClass = newinterfaceClass;
        this.logger = LogFactory.getLog(this.interfaceClass);
        ClassLoader loader = this.deledate == null ? this.interfaceClass.getClassLoader() : this.deledate.getClass().getClassLoader();
        return (T)Proxy.newProxyInstance(loader, new Class[]{this.interfaceClass}, (InvocationHandler)this);
    }

    public <T> T bind(Class<T> newinterfaceClass) {
        return this.bind(null, newinterfaceClass);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String ret = null;
            if (IController.class.isAssignableFrom(this.interfaceClass)) {
                String requestPath = HTTPServiceProxy.getRestPath(this.interfaceClass);
                requestPath = requestPath + "/" + method.getName();
                ret = RestServiceRequester.send(this.remoteHost, requestPath, method.getName(), args);
            } else {
                ret = HTTPServiceRequester.send(this.remoteHost, this.interfaceClass.getName(), method.getName(), args);
            }
            if (method.getReturnType() == Void.TYPE) {
                return null;
            }
            if ("{}".equals(ret)) {
                return null;
            }
            boolean isDynamicModel = false;
            Class<?> clazz = method.getReturnType();
            JavaType javaType = null;
            if (clazz.isArray()) {
                Class genericType = ClassUtil.getArrayClassComponentType(clazz);
                isDynamicModel = IDynamicModel.class.isAssignableFrom(genericType);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                ParameterizedType pt = (ParameterizedType)method.getGenericReturnType();
                Type genericType = pt.getActualTypeArguments()[0];
                isDynamicModel = IDynamicModel.class.isAssignableFrom(genericType.getClass());
                javaType = TypeFactory.defaultInstance().constructParametricType(ArrayList.class, new Class[]{(Class)genericType});
            } else {
                isDynamicModel = IDynamicModel.class.isAssignableFrom(clazz);
            }
            if (isDynamicModel) {
                return JSONUtil.fromJsonString(ret, method.getReturnType());
            }
            if (javaType == null) {
                return JSONUtil.fromJsonString(ret, method.getReturnType());
            }
            if (ret.startsWith("{\"content\":[")) {
                int end = ret.lastIndexOf("}]");
                ret = ret.substring(11, end + 2);
            }
            return JSONUtil.fromJsonString(ret, javaType);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String getRemoteHost(String beanName) {
        block4: {
            String host = null;
            try {
                String vipAddress = HTTPServiceProxy.getVipAddress(beanName);
                Class cls = ClassUtil.getClass(MAPP_CLIENT_CLASS);
                Object info = ClassUtil.callMethod(cls, "getIpAndPort", new Object[]{vipAddress});
                if (info == null) {
                    return HTTPServiceProxy.getRemoteHost();
                }
                String[] arr = (String[])info;
                String ipAddress = arr[0];
                String port = arr[1];
                if (ipAddress != null && port != null) {
                    host = "http://" + ipAddress + ":" + port;
                    return host;
                }
            }
            catch (Throwable e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)"remote host not found.");
            }
        }
        return HTTPServiceProxy.getRemoteHost();
    }

    public static String getRemoteHost() {
        String host = null;
        String ipAddress = SysPropUtil.get(MAPP_MONOLITH_IP);
        String port = SysPropUtil.get(MAPP_MONOLITH_PORT);
        if (ipAddress != null && port != null) {
            host = "http://" + ipAddress + ":" + port;
            return host;
        }
        String address = SysPropUtil.get(MAPP_MONOLITH_ADDRESS);
        if (address != null) {
            return "http://" + address;
        }
        return host;
    }

    public static String getVipAddress(String beanName) {
        String vipAddress = beanName;
        if (beanName.startsWith(YGSOFT_PACKAGE)) {
            vipAddress = beanName.substring(YGSOFT_PACKAGE.length());
            String[] ss = vipAddress.split("\\.");
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (String s : ss) {
                if (SET.contains(s)) break;
                ++index;
            }
            if (index >= 2) {
                sb.append("/").append(ss[0]).append("/").append(ss[1]).append("/");
                for (int i = 2; i < index; ++i) {
                    sb.append(ss[i]);
                }
            }
            vipAddress = sb.toString();
        }
        return vipAddress;
    }

    public static String getRestPath(Class<?> interfaces) {
        String vipAddress = HTTPServiceProxy.getVipAddress(interfaces.getName());
        String sampleName = interfaces.getSimpleName();
        if (sampleName.startsWith("I")) {
            sampleName = sampleName.substring(1);
        }
        if (sampleName.endsWith("Ctrl")) {
            sampleName = sampleName.substring(0, sampleName.length() - 4);
        }
        String lower = sampleName.substring(0, 1).toLowerCase();
        sampleName = lower + sampleName.substring(1);
        return vipAddress + "/" + sampleName;
    }

    static {
        SET.add("data");
        SET.add("impl");
        SET.add("service");
        SET.add("web");
        SET.add("ctrl");
    }
}

