/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.internal.xml;

import java.util.ArrayList;

public class StringList {
    private ArrayList strList;
    private ArrayList objList;
    private String seperator = "\r\n";
    private boolean seperator_set = false;

    private void initList(int iCount) {
        this.strList = new ArrayList(iCount);
        this.objList = new ArrayList(iCount);
    }

    public StringList() {
        this.initList(10);
    }

    public StringList(char seperator) {
        this.setSeperator(seperator);
        this.initList(10);
    }

    private void setSeperator(char sep) {
        this.seperator = String.valueOf(sep);
        this.seperator_set = true;
    }

    private void internalAddString(String str) {
        this.strList.add(str);
    }

    private void internalAddObject(Object obj) {
        this.objList.add(obj);
    }

    public void Add(String str) {
        this.internalAddString(str);
    }

    public void AddObject(String str, Object obj) {
        this.Add(str);
        this.internalAddObject(obj);
    }

    public int getCount() {
        return this.strList.size();
    }

    public int indexOf(String str) {
        return this.strList.indexOf(str);
    }

    private void checkIndex(int iIndex) {
        boolean b;
        boolean bl = b = iIndex >= 0 && iIndex < this.strList.size();
        if (!b) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public String getString(int iIndex) {
        this.checkIndex(iIndex);
        return (String)this.strList.get(iIndex);
    }

    public Object getObject(int iIndex) {
        this.checkIndex(iIndex);
        if (iIndex < this.objList.size()) {
            return this.objList.get(iIndex);
        }
        return null;
    }

    public void clear() {
        this.strList.clear();
        this.objList.clear();
    }

    public String getText() {
        StringBuffer buff = new StringBuffer();
        int n = this.strList.size();
        for (int i = 0; i < n; ++i) {
            if (!this.seperator_set) {
                buff.append((String)this.strList.get(i)).append(this.seperator);
                continue;
            }
            buff.append((String)this.strList.get(i));
            if (i == n - 1) continue;
            buff.append(this.seperator);
        }
        return buff.toString();
    }

    public void setText(String strText) {
        int i;
        this.clear();
        char[] cret = strText.toCharArray();
        int iStart = 0;
        if (!this.seperator_set) {
            while (i < cret.length) {
                iStart = i;
                while (i < cret.length && cret[i] != '\u0000' && cret[i] != '\n' && cret[i] != '\r') {
                    ++i;
                }
                String str = new String(cret, iStart, i - iStart);
                this.Add(str);
                if (i == cret.length) break;
                if (cret[i] == '\r') {
                    ++i;
                }
                if (i != cret.length) {
                    if (cret[i] != '\n') continue;
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            char sep = this.seperator.charAt(0);
            for (i = 0; i < cret.length; ++i) {
                iStart = i;
                while (i < cret.length && cret[i] != '\u0000' && cret[i] != sep) {
                    ++i;
                }
                String str = new String(cret, iStart, i - iStart);
                this.Add(str);
            }
        }
    }

    public void setText(String strText, char sep) {
        this.setSeperator(sep);
        this.setText(strText);
    }

    public void delete(int iIndex) {
        this.checkIndex(iIndex);
        this.strList.remove(iIndex);
        Object obj = this.getObject(iIndex);
        if (obj != null) {
            this.objList.remove(iIndex);
        }
    }
}

