/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.lob;

import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.lob.SerialException;
import com.ygsoft.ecp.service.tool.ConvertUtil;
import com.ygsoft.ecp.service.tool.EncodeUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;

public class SerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;
    private transient String asString;
    private transient InputStream binaryStream;
    static final long serialVersionUID = -8144641928112860441L;

    public SerialBlob(byte[] b) throws SerialException, SQLException {
        this.len = b.length;
        this.buf = new byte[(int)this.len];
        int i = 0;
        while ((long)i < this.len) {
            this.buf[i] = b[i];
            ++i;
        }
        this.origLen = this.len;
    }

    public SerialBlob() {
        byte[] b = new byte[]{};
        this.len = b.length;
        this.buf = new byte[(int)this.len];
        int i = 0;
        while ((long)i < this.len) {
            this.buf[i] = b[i];
            ++i;
        }
        this.origLen = this.len;
    }

    public SerialBlob(Blob blob) throws SerialException, SQLException {
        if (blob == null) {
            throw new SQLException("Cannot instantiate a SerialBlob object with a null Blob object");
        }
        this.len = blob.length();
        this.buf = blob.getBytes(1L, (int)this.len);
        this.blob = blob;
        this.origLen = this.len;
    }

    public byte[] getBytes(long pos, int length) throws SerialException {
        if ((long)length > this.len) {
            length = (int)this.len;
        }
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = this.buf[(int)pos];
            ++pos;
        }
        return b;
    }

    public long length() throws SerialException {
        return this.len;
    }

    public InputStream getBinaryStream() throws SerialException {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.buf);
        return stream;
    }

    public long position(byte[] pattern, long start) throws SerialException, SQLException {
        if (start < 1L || start > this.len) {
            return -1L;
        }
        int pos = (int)start - 1;
        int i = 0;
        long patlen = pattern.length;
        while ((long)pos < this.len) {
            if (pattern[i] == this.buf[pos]) {
                if ((long)(i + 1) == patlen) {
                    return (long)(pos + 1) - (patlen - 1L);
                }
                ++i;
                ++pos;
                continue;
            }
            if (pattern[i] == this.buf[pos]) continue;
            ++pos;
        }
        return -1L;
    }

    public long position(Blob pattern, long start) throws SerialException, SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    public int setBytes(long pos, byte[] bytes) throws SerialException, SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int length) throws SerialException, SQLException {
        int i;
        if (offset < 0 || offset > bytes.length) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if ((long)length > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (length + offset > bytes.length) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset and length that is greater that the Blob buffer");
        }
        for (i = 0; i < length || offset + i + 1 < bytes.length - offset; ++i) {
            this.buf[(int)pos + i] = bytes[offset + i];
        }
        return i;
    }

    public OutputStream setBinaryStream(long pos) throws SerialException, SQLException {
        if (this.blob.setBinaryStream(pos) != null) {
            return this.blob.setBinaryStream(pos);
        }
        throw new SerialException("Unsupported operation. SerialBlob cannot return a writable binary stream, unless instantiated with a Blob object that provides a setBinaryStream() implementation");
    }

    public void truncate(long length) throws SerialException {
        if (length > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        if ((int)length == 0) {
            this.buf = new byte[0];
            this.len = length;
        } else {
            this.len = length;
            this.buf = this.getBytes(1L, (int)this.len);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        try {
            return new String(this.buf, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EcpRuntimeException("", e);
        }
    }

    public void setAsString(String value) {
        if (value == null) {
            try {
                this.truncate(0L);
            }
            catch (SerialException e) {
                throw new EcpRuntimeException("service.SerialBlob.Error", e);
            }
        }
        try {
            this.buf = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EcpRuntimeException("", e);
        }
        this.len = this.buf.length;
    }

    public String getAsBase64String() {
        return EncodeUtil.encodeBytes(this.buf);
    }

    public void setAsBase64String(String value) {
        if (value == null) {
            try {
                this.truncate(0L);
            }
            catch (SerialException e) {
                throw new EcpRuntimeException("service.SerialBlob.asBase64", e);
            }
        } else {
            this.buf = EncodeUtil.decodeToBytes(value);
            this.len = this.buf.length;
        }
    }

    public static final SerialBlob valueOf(Object object) {
        return (SerialBlob)ConvertUtil.toClassObject(object, SerialBlob.class);
    }

    public void free() throws SQLException {
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return null;
    }
}

