/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.log;

import com.ygsoft.ecp.service.internal.log.EcpAccessLogImpl;
import com.ygsoft.ecp.service.internal.log.EcpInvokeLogImpl;
import com.ygsoft.ecp.service.internal.log.EcpLogImpl;
import com.ygsoft.ecp.service.log.IEcpAccessLog;
import com.ygsoft.ecp.service.log.IEcpInvokeLog;
import com.ygsoft.ecp.service.log.IEcpLog;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EcpLogFactory {
    private EcpLogFactory() {
    }

    public static IEcpLog getLog(Class<?> cls) {
        return EcpLogFactory.getLog(cls.getName());
    }

    public static IEcpAccessLog getAccessLog(Class<?> cls) {
        return EcpLogFactory.getAccessLog(cls.getName());
    }

    public static IEcpInvokeLog getInvokeLog(Class<?> cls) {
        return EcpLogFactory.getInvokeLog(cls.getName());
    }

    public static IEcpInvokeLog getInvokeLog(String className) {
        EcpInvokeLogImpl log = new EcpInvokeLogImpl();
        log.setLog(LoggerFactory.getLogger((String)"method-invoke"));
        return log;
    }

    public static IEcpLog getLog(String className) {
        EcpLogImpl log = new EcpLogImpl(className);
        log.setLog(LoggerFactory.getLogger((String)className));
        return log;
    }

    public static IEcpAccessLog getAccessLog(String className) {
        EcpAccessLogImpl log = new EcpAccessLogImpl();
        log.setLog(LoggerFactory.getLogger((String)"http-access"));
        return log;
    }

    public static IEcpLog getSystemLog(Class<?> cls) {
        return EcpLogFactory.getSystemLog(cls.getName());
    }

    public static IEcpLog getSystemLog(String className) {
        StringBuilder sb = new StringBuilder("system.").append(className);
        String newClassName = sb.toString();
        EcpLogImpl log = new EcpLogImpl(newClassName);
        log.setLog(LoggerFactory.getLogger((String)className));
        return log;
    }
}

