/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.log;

import com.ygsoft.ecp.framework.i18n.LocaleHolder;
import java.util.Locale;
import java.util.TimeZone;

public final class LogContextHolder {
    private final ThreadLocal<ILogContext> logContainer = new ThreadLocal();
    public static final LogContextHolder INSTANCE = new LogContextHolder();

    private LogContextHolder() {
    }

    public ILogContext getLogContext() {
        return this.logContainer.get();
    }

    public void setLogContext(ILogContext logContext) {
        this.logContainer.set(logContext);
    }

    public void clearLogContext() {
        this.logContainer.remove();
    }

    public String getIp() {
        return this.logContainer.get() == null ? null : this.logContainer.get().getIp();
    }

    public String getUserName() {
        return this.logContainer.get() == null ? null : this.logContainer.get().getUserName();
    }

    public String getUserId() {
        return this.logContainer.get() == null ? null : this.logContainer.get().getUserId();
    }

    public String getLoginOrgName() {
        return this.logContainer.get() == null ? null : this.logContainer.get().getLoginOrgName();
    }

    public String getOrgName() {
        return this.logContainer.get() == null ? null : this.logContainer.get().getOrgName();
    }

    public Locale getLocale() {
        if (this.logContainer.get() == null) {
            return LocaleHolder.INSTANCE.getLocale();
        }
        ILogContext lc = this.logContainer.get();
        Locale local = lc.getLocale();
        if (local == null) {
            return LocaleHolder.INSTANCE.getLocale();
        }
        return local;
    }

    public TimeZone getTimeZone() {
        return this.logContainer.get() == null ? TimeZone.getDefault() : this.logContainer.get().getTimeZone();
    }

    public String getUniqueKey() {
        return this.logContainer.get() == null ? null : this.logContainer.get().getUniqueKey();
    }

    public static interface ILogContext {
        public String getIp();

        public String getUserId();

        public String getUserName();

        public String getLoginOrgName();

        public String getOrgName();

        public Locale getLocale();

        public String getUniqueKey();

        public TimeZone getTimeZone();
    }
}

