/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.mail;

import java.util.Properties;

public final class MailboxConfig {
    public static final String DEFAULT_PROTOCOL = Protocol.SMTP.toString();
    public static final int DEFAULT_SMTP_PORT = 25;
    public static final boolean DEFAULT_SMTP_AUTH = false;
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String MAIL_USER = "mail.user";
    public static final String MAIL_PASSWORD = "mail.password";
    private Properties properties;

    public MailboxConfig() {
        this.properties = new Properties();
    }

    public MailboxConfig(Properties newproperties) {
        if (null == newproperties) {
            throw new IllegalArgumentException("Construct MailboxConfig object fail: properties is null.");
        }
        this.properties = newproperties;
    }

    public static MailboxConfig valueOf(Properties properties) {
        return MailboxConfig.parse(properties);
    }

    public static MailboxConfig parse(Properties properties) {
        return new MailboxConfig(properties);
    }

    public Properties toProperties() {
        return this.properties;
    }

    public String getProtocol() {
        return this.properties.getProperty(MAIL_TRANSPORT_PROTOCOL, DEFAULT_PROTOCOL);
    }

    public void setProtocol(String protocol) {
        this.properties.put(MAIL_TRANSPORT_PROTOCOL, protocol);
    }

    public String getHost() {
        return this.properties.getProperty(this.getPropKeyHost());
    }

    public void setHost(String host) {
        this.properties.put(this.getPropKeyHost(), host);
    }

    public int getPort() {
        return Integer.parseInt(this.properties.getProperty(this.getPropKeyPort(), String.valueOf(25)));
    }

    public void setPort(int port) {
        this.properties.put(this.getPropKeyPort(), String.valueOf(port));
    }

    public String getUser() {
        return this.properties.getProperty(MAIL_USER);
    }

    public void setUser(String user) {
        this.properties.put(MAIL_USER, user);
    }

    public String getPassword() {
        return this.properties.getProperty(MAIL_PASSWORD);
    }

    public void setPassword(String password) {
        this.properties.put(MAIL_PASSWORD, password);
    }

    public boolean isAuth() {
        String isAuth = this.properties.getProperty(this.getPropKeyAuth(), String.valueOf(false));
        return "true".equalsIgnoreCase(isAuth);
    }

    public void setAuth(boolean auth) {
        this.properties.put(this.getPropKeyAuth(), String.valueOf(auth));
    }

    public String getPropKeyHost() {
        return "mail." + this.getProtocol().toLowerCase() + ".host";
    }

    public String getPropKeyPort() {
        return "mail." + this.getProtocol().toLowerCase() + ".port";
    }

    public String getPropKeyAuth() {
        return "mail." + this.getProtocol().toLowerCase() + ".auth";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        SMTP,
        POP3,
        IMAP;

    }
}

