/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.script;

import bsh.Interpreter;
import com.ygsoft.ecp.service.exception.ScriptException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.script.JavaScriptEvaluator;
import com.ygsoft.ecp.service.script.ScriptEvaluator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BshEvaluator
implements ScriptEvaluator {
    private static final IEcpLog log = EcpLogFactory.getLog(JavaScriptEvaluator.class);

    @Override
    public boolean evaluateCondition(String condition, Map<String, Object> context) {
        if (condition == null || condition.trim().length() == 0) {
            return true;
        }
        Object eval = this.evaluateExpression(condition, context, Boolean.class);
        try {
            return (Boolean)eval;
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("BshEvaluator -> The result of condition " + condition + " cannot be converted to boolean");
            }
            throw new ScriptException("Result cannot be converted to boolean", ex);
        }
    }

    @Override
    public Object evaluateExpression(String expr, Map<String, Object> context, Class<?> resultClass) {
        Interpreter interpreter = new Interpreter();
        try {
            this.prepareContext(interpreter, context);
            Object eval = interpreter.eval(expr);
            if (eval instanceof Integer) {
                eval = Long.valueOf(((Integer)eval).intValue()).intValue();
            }
            if (log.isDebugEnabled()) {
                log.debug("BshScriptEvaluator -> Java expression " + expr + " is evaluated to " + eval);
            }
            return eval;
        }
        catch (Throwable ee) {
            if (log.isErrorEnabled()) {
                log.error("BshEvaluator -> The result of expression " + expr + " can't be evaluated - error message=" + ee.getMessage());
            }
            throw new ScriptException("Result cannot be evaluated", ee);
        }
    }

    private void prepareContext(Interpreter interpreter, Map<String, Object> context) throws Exception {
        if (context == null) {
            return;
        }
        for (Map.Entry<String, Object> me : context.entrySet()) {
            interpreter.set(me.getKey(), me.getValue());
        }
    }

    @Override
    public Object execute(String expr, Map<String, Object> context) {
        return this.evaluateExpression(expr, context, null);
    }

    @Override
    public void release() {
    }
}

