/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.datasource.DataSourceWrapper;
import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.dataaccess.IHibernateTemplate;
import com.ygsoft.ecp.service.dataaccess.exception.DataaccessException;
import com.ygsoft.ecp.service.datasource.DataSourceSwapper;
import com.ygsoft.ecp.service.datasource.DatasourceManager;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.VPDStatusHolder;
import com.ygsoft.ecp.service.tool.VPDUtil;
import java.sql.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClosureUtil {
    private static Boolean isMasterSlave = null;
    static IHibernateTemplate hibernateTemplate = null;
    private static ThreadLocal<Boolean> status = new ThreadLocal();
    private static ThreadLocal<String> secret = new ThreadLocal();
    private static final IEcpLog LOG = EcpLogFactory.getLog(ClosureUtil.class);

    private ClosureUtil() {
    }

    public static String getSecretLevel() {
        return secret.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doInSecret(String secretLevel, Closure closure) {
        Object result = null;
        try {
            secret.set(secretLevel);
            result = closure.execute();
            Object var4_3 = null;
            if (secret.get() != null) {
                secret.set(null);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (secret.get() != null) {
                secret.set(null);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object doInSchema(String schema, Closure closure) {
        Object object;
        ClosureUtil.checkInTransaction();
        String mainSchema = RuntimeEnvUtil.getINSTANCE().getMainCompID();
        Connection conn = null;
        try {
            try {
                conn = DatasourceManager.INSTANCE.getDefaultDataSource().getConnection();
                conn.createStatement().execute("USE " + schema);
                object = closure.execute();
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not alter connection to schema [" + schema + "]", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                conn.createStatement().execute("USE " + mainSchema);
            }
            catch (Exception e2) {
                throw new RuntimeException("Could not alter connection to main schema [" + mainSchema + "]", e2);
            }
            try {
                if (conn == null) throw throwable;
                if (conn.isClosed()) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            throw new RuntimeException("Could not alter connection to main schema [" + mainSchema + "]", e2);
        }
        conn.createStatement().execute("USE " + mainSchema);
        try {}
        catch (Exception exception) {
            // empty catch block
            return object;
        }
        if (conn == null) return object;
        if (conn.isClosed()) return object;
        conn.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doInSlave(String jndiName, Closure closure) {
        Object result = null;
        ClosureUtil.checkNotInTransaction();
        try {
            DataSourceSwapper.INSTANCE.set(jndiName);
            result = closure.execute();
            Object var4_3 = null;
            if (DataSourceSwapper.INSTANCE.get() != null) {
                DataSourceSwapper.INSTANCE.set(null);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (DataSourceSwapper.INSTANCE.get() != null) {
                DataSourceSwapper.INSTANCE.set(null);
            }
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doInSlaveDatasource(Closure closure) {
        Object result;
        ClosureUtil.checkNotInTransaction();
        try {
            TokenHolder.INSTANCE.batchSetMulDatasourceSlaveAllTag(true);
            result = closure.execute();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TokenHolder.INSTANCE.batchRemoveMulDatasourceSlaveAllTag();
            throw throwable;
        }
        TokenHolder.INSTANCE.batchRemoveMulDatasourceSlaveAllTag();
        return result;
    }

    public static Object doInSlave(Closure closure) {
        if (DataSourceWrapper.IS_MASTER_SLAVE_MODE && null == DatasourceManager.INSTANCE.getJndiDataSource("fmismain")) {
            ClosureUtil.doInSlaveDatasource(closure);
        }
        return ClosureUtil.doInSlave("fmismain", closure);
    }

    public static Object doInSlave(Class<?> clazz, String method, Closure closure) {
        return ClosureUtil.doInSlave(closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object doInECP(String compId, Closure closure) {
        Object result = null;
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (!DatabaseType.Oracle.equals((Object)curDbType) && !DatabaseType.DM.equals((Object)curDbType)) {
            return ClosureUtil.doInCommon(compId, closure);
        }
        String compID = RuntimeEnvUtil.INSTANCE.getRealCompID(compId);
        String nowVPDCompId = null;
        String nowVPDState = "NAN";
        ClosureUtil.checkCompId(compID);
        ClosureUtil.checkInTransaction();
        if (RuntimeEnvUtil.INSTANCE.isPlus()) {
            nowVPDCompId = VPDUtil.getVPDCompID();
            nowVPDState = VPDUtil.getVPDStatus();
        } else {
            nowVPDCompId = VPDStatusHolder.getVPDStatus();
        }
        RuntimeException ex = null;
        try {
            try {
                VPDStatusHolder.setVPDStatus(compID);
                status = new ThreadLocal();
                status.set(true);
                result = closure.execute();
                if (ClosureUtil.isDebugEnabled()) {
                    LOG.debug("GAP\u73af\u5883\u4e2d\u8c03\u7528ECP\u5b8c\u6210\uff0c\u5f00\u59cbflush ECP\u4e2dHibernate Session\u6570\u636e\uff0c\u53d1\u9001\u76f8\u5173SQL\u8bed\u53e5");
                }
                ClosureUtil.flushHibernateSession();
            }
            catch (RuntimeException error) {
                ex = error;
                Object var10_9 = null;
                status.remove();
                if (ClosureUtil.isDebugEnabled()) {
                    LOG.debug("GAP\u73af\u5883\u4e2d\u8c03\u7528ECP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
                }
                ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
                if (ex == null) return result;
                throw ex;
            }
            Object var10_8 = null;
            status.remove();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            status.remove();
            if (ClosureUtil.isDebugEnabled()) {
                LOG.debug("GAP\u73af\u5883\u4e2d\u8c03\u7528ECP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
            }
            ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
            if (ex == null) throw throwable;
            throw ex;
        }
        if (ClosureUtil.isDebugEnabled()) {
            LOG.debug("GAP\u73af\u5883\u4e2d\u8c03\u7528ECP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
        }
        ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
        if (ex == null) return result;
        throw ex;
    }

    public static Object doInECPWithoutVPD(Closure closure) {
        return ClosureUtil.doInECP("-1", closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object doInGAP(Closure closure) {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (!DatabaseType.Oracle.equals((Object)curDbType) && !DatabaseType.DM.equals((Object)curDbType)) {
            return closure.execute();
        }
        String nowVPDCompId = null;
        String nowVPDState = "NAN";
        ClosureUtil.checkInTransaction();
        if (RuntimeEnvUtil.INSTANCE.isPlus()) {
            nowVPDCompId = VPDUtil.getVPDCompID();
            nowVPDState = VPDUtil.getVPDStatus();
        } else {
            nowVPDCompId = VPDStatusHolder.getVPDStatus();
        }
        if (ClosureUtil.isDebugEnabled()) {
            LOG.debug("\u5f53\u524dECP\u903b\u8f91\u5b58\u5728\u95ed\u5305\u73af\u5883\uff0c\u4e0a\u4e0b\u6587\u7684VPD compId\u4e3a\uff1a" + nowVPDCompId + "\uff0c\u5f53\u524dvpdState\u4e3a" + nowVPDState);
        }
        if (ClosureUtil.isDebugEnabled()) {
            LOG.debug("ECP\u73af\u5883\u4e2d\u5f00\u59cb\u8c03\u7528GAP\u903b\u8f91\uff0c\u5f00\u59cbflush ECP\u4e2dHibernate Session\u6570\u636e\uff0c\u53d1\u9001\u76f8\u5173SQL\u8bed\u53e5");
        }
        ClosureUtil.flushHibernateSession();
        RuntimeException ex = null;
        Object result = null;
        try {
            try {
                status.set(true);
                result = closure.execute();
            }
            catch (RuntimeException error) {
                ex = error;
                Object var8_7 = null;
                status.remove();
                if (ClosureUtil.isDebugEnabled()) {
                    LOG.debug("\u8c03\u7528GAP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
                }
                ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
                if (ex == null) return result;
                throw ex;
            }
            Object var8_6 = null;
            status.remove();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            status.remove();
            if (ClosureUtil.isDebugEnabled()) {
                LOG.debug("\u8c03\u7528GAP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
            }
            ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
            if (ex == null) throw throwable;
            throw ex;
        }
        if (ClosureUtil.isDebugEnabled()) {
            LOG.debug("\u8c03\u7528GAP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
        }
        ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
        if (ex == null) return result;
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object doInVPDComp(String compId, Closure closure) {
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (!DatabaseType.Oracle.equals((Object)curDbType) && !DatabaseType.DM.equals((Object)curDbType)) {
            return ClosureUtil.doInCommon(compId, closure);
        }
        String compID = RuntimeEnvUtil.INSTANCE.getRealCompID(compId);
        String nowVPDCompId = null;
        String nowVPDState = "NAN";
        ClosureUtil.checkCompId(compID);
        ClosureUtil.checkInTransaction();
        if (RuntimeEnvUtil.INSTANCE.isPlus()) {
            nowVPDCompId = VPDUtil.getVPDCompID();
            nowVPDState = VPDUtil.getVPDStatus();
        } else {
            nowVPDCompId = VPDStatusHolder.getVPDStatus();
        }
        if (ClosureUtil.isDebugEnabled()) {
            LOG.debug("\u5f53\u524dECP\u903b\u8f91\u5b58\u5728\u95ed\u5305\u73af\u5883\uff0c\u4e0a\u4e0b\u6587\u7684VPD compId:" + nowVPDCompId + "\uff0c\u5f53\u524dvpdState\u4e3a" + nowVPDState + "\uff0c\u5207\u6362\u7684compId\u4e3a:" + compID + "\uff0c\u5148flush hibernate Session\u6570\u636e\uff0c\u751f\u6210\u76f8\u5173SQL\u8bed\u53e5");
        }
        ClosureUtil.flushHibernateSession();
        RuntimeException ex = null;
        Object result = null;
        try {
            try {
                VPDStatusHolder.setVPDStatus(compID);
                status.set(true);
                result = closure.execute();
                if (ClosureUtil.isDebugEnabled()) {
                    LOG.debug("\u5207\u6362\u7684compId:" + compID + "\uff0c\u903b\u8f91\u6267\u884c\u5b8c\u6210\uff0c\u5f00\u59cbflush hibernate session\u6570\u636e\uff0c\u751f\u6210\u76f8\u5173SQL");
                }
                ClosureUtil.flushHibernateSession();
            }
            catch (RuntimeException error) {
                ex = error;
                Object var10_9 = null;
                status.remove();
                if (ClosureUtil.isDebugEnabled()) {
                    LOG.debug("\u5f53\u524dECP\u903b\u8f91\u5b58\u5728\u95ed\u5305\u73af\u5883\uff0c\u5207\u6362\u56de\u539f\u6765\u7684compId\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
                }
                ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
                if (ex == null) return result;
                throw ex;
            }
            Object var10_8 = null;
            status.remove();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            status.remove();
            if (ClosureUtil.isDebugEnabled()) {
                LOG.debug("\u5f53\u524dECP\u903b\u8f91\u5b58\u5728\u95ed\u5305\u73af\u5883\uff0c\u5207\u6362\u56de\u539f\u6765\u7684compId\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
            }
            ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
            if (ex == null) throw throwable;
            throw ex;
        }
        if (ClosureUtil.isDebugEnabled()) {
            LOG.debug("\u5f53\u524dECP\u903b\u8f91\u5b58\u5728\u95ed\u5305\u73af\u5883\uff0c\u5207\u6362\u56de\u539f\u6765\u7684compId\uff1a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
        }
        ClosureUtil.afterVPD(nowVPDCompId, nowVPDState);
        if (ex == null) return result;
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object doInCommon(String compId, Closure closure) {
        Object result;
        block23: {
            RuntimeException ex;
            String nowVPDCompId;
            block20: {
                result = null;
                String compID = RuntimeEnvUtil.INSTANCE.getRealCompID(compId);
                nowVPDCompId = null;
                ClosureUtil.checkCompId(compID);
                nowVPDCompId = RuntimeEnvUtil.INSTANCE.isPlus() ? VPDUtil.getVPDCompID() : VPDStatusHolder.getVPDStatus();
                ex = null;
                VPDStatusHolder.setVPDStatus(compID);
                status = new ThreadLocal();
                status.set(true);
                result = closure.execute();
                Object var8_6 = null;
                status.remove();
                if (ClosureUtil.isDebugEnabled()) {
                    LOG.debug("GAP\u73af\u5883\u4e2d\u8c03\u7528ECP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId);
                }
                try {
                    if (RuntimeEnvUtil.INSTANCE.isPlus()) {
                        VPDUtil.setVPDStatusAndCompId(nowVPDCompId, true);
                    } else {
                        VPDStatusHolder.setVPDStatus(nowVPDCompId);
                    }
                }
                catch (Exception erx) {
                    if (!LOG.isErrorEnabled()) break block20;
                    LOG.error("\u95ed\u5305\u6267\u884c\u4ea7\u751f\u5f02\u5e38\uff0c\u4e8b\u52a1\u56de\u6eda\uff0c\u5207\u6362\u56de\u539fcompId\u5931\u8d25\uff0c\u539fcompId\u4e3a" + nowVPDCompId);
                }
            }
            if (ex != null) {
                throw ex;
            }
            break block23;
            {
                catch (RuntimeException error) {
                    block21: {
                        ex = error;
                        Object var8_7 = null;
                        status.remove();
                        if (ClosureUtil.isDebugEnabled()) {
                            LOG.debug("GAP\u73af\u5883\u4e2d\u8c03\u7528ECP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId);
                        }
                        try {
                            if (RuntimeEnvUtil.INSTANCE.isPlus()) {
                                VPDUtil.setVPDStatusAndCompId(nowVPDCompId, true);
                            } else {
                                VPDStatusHolder.setVPDStatus(nowVPDCompId);
                            }
                        }
                        catch (Exception erx) {
                            if (!LOG.isErrorEnabled()) break block21;
                            LOG.error("\u95ed\u5305\u6267\u884c\u4ea7\u751f\u5f02\u5e38\uff0c\u4e8b\u52a1\u56de\u6eda\uff0c\u5207\u6362\u56de\u539fcompId\u5931\u8d25\uff0c\u539fcompId\u4e3a" + nowVPDCompId);
                        }
                    }
                    if (ex != null) {
                        throw ex;
                    }
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Object var8_8 = null;
                    status.remove();
                    if (ClosureUtil.isDebugEnabled()) {
                        LOG.debug("GAP\u73af\u5883\u4e2d\u8c03\u7528ECP\u5b8c\u6210\uff0c\u8bbe\u7f6eVPD compId\u4e3a\u4e4b\u524dECP\u4e0a\u4e0b\u6587\u7684compId\uff0c\u503c\u4e3a\uff1a" + nowVPDCompId);
                    }
                    try {
                        if (RuntimeEnvUtil.INSTANCE.isPlus()) {
                            VPDUtil.setVPDStatusAndCompId(nowVPDCompId, true);
                        } else {
                            VPDStatusHolder.setVPDStatus(nowVPDCompId);
                        }
                    }
                    catch (Exception erx) {
                        if (!LOG.isErrorEnabled()) break block22;
                        LOG.error("\u95ed\u5305\u6267\u884c\u4ea7\u751f\u5f02\u5e38\uff0c\u4e8b\u52a1\u56de\u6eda\uff0c\u5207\u6362\u56de\u539fcompId\u5931\u8d25\uff0c\u539fcompId\u4e3a" + nowVPDCompId);
                    }
                }
                if (ex != null) {
                    throw ex;
                }
                throw throwable;
            }
        }
        return result;
    }

    private static void afterVPD(String nowVPDCompId, String nowVPDState) {
        block7: {
            try {
                if (RuntimeEnvUtil.INSTANCE.isPlus()) {
                    if ("0".equals(nowVPDState)) {
                        VPDUtil.setVPDStatusAndCompId(nowVPDCompId, false);
                    } else if ("1".equals(nowVPDState)) {
                        VPDUtil.setVPDStatusAndCompId(nowVPDCompId, true);
                    }
                } else {
                    VPDStatusHolder.setVPDStatus(nowVPDCompId);
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error("\u95ed\u5305\u6267\u884c\u4ea7\u751f\u5f02\u5e38\uff0c\u4e8b\u52a1\u56de\u6eda\uff0c\u5207\u6362\u56de\u539fcompId\u5931\u8d25\uff0c\u539fcompId\u4e3a" + nowVPDCompId + "\uff0c\u539fvpdState\u4e3a" + nowVPDState);
            }
        }
    }

    private static boolean isDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    public static Object doInWithoutVPD(Closure closure) {
        return ClosureUtil.doInVPDComp("-1", closure);
    }

    public static boolean isInClosure() {
        return status.get() != null && status.get() != false;
    }

    private static void flushHibernateSession() {
        IHibernateTemplate service = null;
        service = hibernateTemplate != null ? hibernateTemplate : OSGiUtil.getService(IHibernateTemplate.class);
        if (service == null) {
            throw new DataaccessException("\u83b7\u53d6\u4e0d\u5230" + IHibernateTemplate.class.getName() + "OSGi\u670d\u52a1");
        }
        service.flushSession();
    }

    private static void checkCompId(String compId) {
        if (StringUtil.isEmptyString(compId)) {
            throw new DataaccessException("compId\u7ec4\u7ec7\u4e3a\u7a7a");
        }
    }

    private static void checkNotInTransaction() {
        if (VPDUtil.isTransactional()) {
            throw new DataaccessException("\u6267\u884c\u4e3b\u4ece\u5e93\u5207\u6362\u95ed\u5305\u5fc5\u987b\u5728\u975e\u4e8b\u52a1\u73af\u5883\u5185\u8fd0\u884c");
        }
    }

    private static void checkInTransaction() {
        if (!VPDUtil.isTransactional()) {
            throw new DataaccessException("\u6267\u884cVPD\u7b56\u7565\u76f8\u5173\u7684\u903b\u8f91\u5fc5\u987b\u5728\u4e8b\u52a1\u5185\u8fd0\u884c");
        }
    }

    public static interface Closure {
        public Object execute();
    }
}

