/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.cons.NumberConst;
import com.ygsoft.ecp.service.date.EcpDate;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.log.LogContextHolder;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public final class DateUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(DateUtil.class);
    private static Map<String, DateFormat> formatters = new HashMap<String, DateFormat>();
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss sss";
    public static final String SECOND_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String TH3RD_PATTERN = "yyyyMMddHHmmss";
    public static final String DAY_PATTERN = "yyyy-MM-dd";
    public static final long DAY_SECONDS = NumberConst.TWENTY_FOUR * NumberConst.SIXTY * NumberConst.SIXTY;
    public static final long DAY_MILLI_SECONDS = DAY_SECONDS * (long)NumberConst.THOUSAND.intValue();
    public static final String TIMEZONE_CONVERT_ENABLE = "ygsoft.timezone.enable";

    private DateUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateFormat getDateFormatter(String pattern) {
        if (StringUtil.isNullOrTrimEmptyString(pattern)) {
            return formatters.get(DEFAULT_PATTERN);
        }
        DateFormat df = formatters.get(pattern);
        if (null != df) {
            return df;
        }
        Map<String, DateFormat> map = formatters;
        synchronized (map) {
            df = formatters.get(pattern);
            if (null == df) {
                df = new SimpleDateFormat(pattern);
                formatters.put(pattern, df);
            }
        }
        return df;
    }

    public static String formate(String pattern, Long millseconds) {
        if (millseconds == null) {
            return null;
        }
        return DateUtil.getDateFormatter(pattern).format(new Date(millseconds));
    }

    public static Date getCurrentSystemTime() {
        Date srcDate = new Date();
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return DateUtil.obj2Date(srcDate);
        }
        if (DateUtil.isSameTimeZone()) {
            return DateUtil.obj2Date(srcDate);
        }
        return DateUtil.convertDateGMT(srcDate, LogContextHolder.INSTANCE.getTimeZone());
    }

    public static EcpDate getCurrentSystemTimeOfEcp() {
        EcpDate epcDate = new EcpDate();
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return epcDate;
        }
        if (DateUtil.isSameTimeZone()) {
            return epcDate;
        }
        Date finalDate = DateUtil.convertDateGMT(epcDate.toDate());
        return new EcpDate(finalDate);
    }

    public static Date str2ShortDate(String date) {
        return DateUtil.str2Date(DAY_PATTERN, date);
    }

    public static Date str2LongDate(String date) {
        return DateUtil.str2Date(SECOND_PATTERN, date);
    }

    public static String shortDate2Str(Date date) {
        return DateUtil.date2Str(DAY_PATTERN, date);
    }

    public static String longDate2Str(Date date) {
        return DateUtil.date2Str(SECOND_PATTERN, date);
    }

    public static Date str2Date(String pattern, String date) {
        if (!StringUtils.isBlank((CharSequence)date)) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            try {
                return sdf.parse(date);
            }
            catch (ParseException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage(), e);
                }
                return null;
            }
        }
        return null;
    }

    public static Date str2Date(String dateStr) {
        Date date = DateUtil.str2Date(SECOND_PATTERN, dateStr);
        if (date == null) {
            date = DateUtil.str2Date(DAY_PATTERN, dateStr);
        }
        if (date == null) {
            date = DateUtil.str2Date(DEFAULT_PATTERN, dateStr);
        }
        return date;
    }

    public static Date convertDate(Date srcDate, TimeZone destTimeZone) {
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return srcDate;
        }
        if (srcDate == null || destTimeZone == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(SECOND_PATTERN);
        String dateStr = sdf.format(srcDate);
        try {
            sdf.setTimeZone(destTimeZone);
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getMessage(), e);
            }
            return null;
        }
    }

    public static String date2Str(String pattern, Date date) {
        if (!StringUtils.isBlank((CharSequence)pattern) && date != null) {
            try {
                return new SimpleDateFormat(pattern).format(date);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage(), e);
                }
                return null;
            }
        }
        return null;
    }

    public static String date2Str(Date date) {
        if (date != null) {
            return new SimpleDateFormat(SECOND_PATTERN).format(date);
        }
        return null;
    }

    public static TimeZone getSysTimeZone() {
        return TimeZone.getDefault();
    }

    public static Date convertDateGMT(Object srcDate, Object destTimeZone) {
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return DateUtil.obj2Date(srcDate);
        }
        if (srcDate == null) {
            return null;
        }
        TimeZone sysTimeZone = DateUtil.getSysTimeZone();
        if (sysTimeZone == destTimeZone) {
            return DateUtil.obj2Date(srcDate);
        }
        if (Date.class.isAssignableFrom(srcDate.getClass())) {
            return DateUtil.convertDateGMT((Date)srcDate, sysTimeZone, (TimeZone)destTimeZone);
        }
        if (srcDate instanceof String) {
            return DateUtil.convertDateGMT((String)srcDate, sysTimeZone, (TimeZone)destTimeZone);
        }
        return null;
    }

    public static Date convertDateGMT(Object srcDate) {
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return DateUtil.obj2Date(srcDate);
        }
        if (srcDate == null) {
            return null;
        }
        if (DateUtil.isSameTimeZone()) {
            return DateUtil.obj2Date(srcDate);
        }
        return DateUtil.convertDateGMT(srcDate, (Object)LogContextHolder.INSTANCE.getTimeZone());
    }

    public static EcpDate convertEcpDateGMT(Object srcDate) {
        EcpDate epcDate = (EcpDate)((Object)srcDate);
        if (srcDate == null) {
            return epcDate;
        }
        Date finalDate = DateUtil.convertDateGMT(epcDate.toDate());
        return new EcpDate(finalDate);
    }

    private static boolean isTimeZoneConvertEnable() {
        return StringUtil.isEquals(System.getProperty(TIMEZONE_CONVERT_ENABLE), "true");
    }

    private static Date obj2Date(Object srcDate) {
        if (srcDate == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(Date.class)) {
            return (Date)srcDate;
        }
        if (srcDate instanceof String) {
            return DateUtil.str2Date(DEFAULT_PATTERN, (String)srcDate);
        }
        return null;
    }

    private static boolean isSameTimeZone() {
        return LogContextHolder.INSTANCE.getTimeZone() == DateUtil.getSysTimeZone();
    }

    public static Date reverseDateGMT(Object srcDate) {
        if (srcDate == null) {
            return null;
        }
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return DateUtil.obj2Date(srcDate);
        }
        if (DateUtil.isSameTimeZone()) {
            return DateUtil.obj2Date(srcDate);
        }
        return DateUtil.convertDateGMT(LogContextHolder.INSTANCE.getTimeZone(), srcDate);
    }

    public static EcpDate reverseEcpDateGMT(Object srcDate) {
        EcpDate epcDate = (EcpDate)((Object)srcDate);
        if (srcDate == null) {
            return epcDate;
        }
        Date finalDate = DateUtil.reverseDateGMT(epcDate.toDate());
        return new EcpDate(finalDate);
    }

    public static Date convertDateGMT(Date srcDate, TimeZone destTimeZone) {
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return srcDate;
        }
        if (srcDate == null || destTimeZone == null) {
            return null;
        }
        if (destTimeZone == DateUtil.getSysTimeZone()) {
            return srcDate;
        }
        return DateUtil.convertDateGMT(srcDate, DateUtil.getSysTimeZone(), destTimeZone);
    }

    public static Date convertDateGMT(Date srcDate, TimeZone srcTimeZone, TimeZone destTimeZone) {
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return srcDate;
        }
        if (srcDate != null) {
            if (srcTimeZone == null) {
                srcTimeZone = DateUtil.getSysTimeZone();
            }
            if (destTimeZone == null) {
                destTimeZone = DateUtil.getSysTimeZone();
            }
            if (srcTimeZone == destTimeZone) {
                return srcDate;
            }
            Long time = srcDate.getTime();
            Long sourceRelativelyGMT = time - (long)srcTimeZone.getRawOffset();
            Long targetRelativelyGMT = time - (long)destTimeZone.getRawOffset();
            return new Date(time - sourceRelativelyGMT + targetRelativelyGMT);
        }
        return null;
    }

    public static Date convertDateGMT(String srcDate, TimeZone destTimeZone) {
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return DateUtil.obj2Date(srcDate);
        }
        if (StringUtils.isBlank((CharSequence)srcDate) || destTimeZone == null) {
            return null;
        }
        return DateUtil.convertDateGMT(srcDate, DateUtil.getSysTimeZone(), destTimeZone);
    }

    public static Date convertDateGMT(String srcDate, TimeZone srcTimeZone, TimeZone destTimeZone) {
        if (!DateUtil.isTimeZoneConvertEnable()) {
            return DateUtil.obj2Date(srcDate);
        }
        if (StringUtils.isBlank((CharSequence)srcDate) || srcTimeZone == null || destTimeZone == null) {
            return null;
        }
        if (srcTimeZone == destTimeZone) {
            return DateUtil.obj2Date(srcDate);
        }
        return DateUtil.convertDateGMT(DateUtil.str2Date(srcDate), srcTimeZone, destTimeZone);
    }

    public static long getWorkingMills(Date endDateTime, Date startDateTime) {
        Date startDate = startDateTime;
        Date endDate = endDateTime;
        if (startDateTime.getTime() > endDateTime.getTime()) {
            startDate = endDateTime;
            endDate = startDateTime;
        }
        long result = 0L;
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        boolean startTimeIsWorkDay = startCal.get(7) == 7 || startCal.get(7) == 1;
        boolean endTimeIsWorkDay = endCal.get(7) == 7 || endCal.get(7) == 1;
        int workDay = DateUtil.getWorkingDaysBetweenTwoDates(endDate, startDate);
        if (startTimeIsWorkDay && endTimeIsWorkDay) {
            return workDay * NumberConst.TWENTY_FOUR * NumberConst.SIXTY * NumberConst.SIXTY;
        }
        if (startTimeIsWorkDay && !endTimeIsWorkDay) {
            result = (long)workDay * DAY_SECONDS;
            String endDateString = DateUtil.formate(DAY_PATTERN, endDate.getTime());
            Date temp = DateUtil.str2Date(DAY_PATTERN, endDateString);
            result += (endDate.getTime() - temp.getTime()) / (long)NumberConst.THOUSAND.intValue();
        } else if (!startTimeIsWorkDay && endTimeIsWorkDay) {
            result = (long)workDay * DAY_SECONDS;
            String startDateString = DateUtil.formate(DAY_PATTERN, startDate.getTime() + DAY_MILLI_SECONDS);
            Date temp = DateUtil.str2Date(DAY_PATTERN, startDateString);
            result += (temp.getTime() - startDate.getTime()) / (long)NumberConst.THOUSAND.intValue();
        } else if (workDay > 0) {
            result = workDay * NumberConst.TWENTY_FOUR * NumberConst.SIXTY * NumberConst.SIXTY;
            String startDateString = DateUtil.formate(DAY_PATTERN, startDate.getTime() + DAY_MILLI_SECONDS);
            Date temp = DateUtil.str2Date(DAY_PATTERN, startDateString);
            result += (temp.getTime() - startDate.getTime()) / (long)NumberConst.THOUSAND.intValue();
            String endDateString = DateUtil.formate(DAY_PATTERN, endDate.getTime());
            temp = DateUtil.str2Date(DAY_PATTERN, endDateString);
            result += (endDate.getTime() - temp.getTime()) / (long)NumberConst.THOUSAND.intValue();
        } else {
            result = (endDate.getTime() - startDate.getTime()) / (long)NumberConst.THOUSAND.intValue();
        }
        return result;
    }

    public static int getWorkingDaysBetweenTwoDates(Date startDate, Date endDate) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        int workDays = 0;
        if (startCal.getTimeInMillis() == endCal.getTimeInMillis()) {
            return 0;
        }
        if (startCal.getTimeInMillis() > endCal.getTimeInMillis()) {
            startCal.setTime(endDate);
            endCal.setTime(startDate);
        }
        do {
            startCal.add(5, 1);
            if (startCal.get(7) == 7 || startCal.get(7) == 1) continue;
            ++workDays;
        } while (startCal.getTimeInMillis() < endCal.getTimeInMillis());
        return workDays;
    }

    static {
        formatters.put(DEFAULT_PATTERN, new SimpleDateFormat(DEFAULT_PATTERN));
    }
}

