/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.internal.i18n.DBResourceAccessService;
import com.ygsoft.ecp.service.internal.i18n.I18nConfig;
import com.ygsoft.ecp.service.log.LogContextHolder;
import com.ygsoft.ecp.service.model.IValueObject;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.I18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.MutilingualUtil;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcpI18nUtil
implements IEcpToolLogic {
    private static Locale defaultGlobalLocale;

    private EcpI18nUtil() {
    }

    public static Locale getDefaultGlobalLocale() {
        if (defaultGlobalLocale == null) {
            try {
                defaultGlobalLocale = MutilingualUtil.getDefaultLocale();
            }
            catch (Exception e) {
                defaultGlobalLocale = Locale.getDefault();
            }
        }
        return defaultGlobalLocale;
    }

    public static Locale handleLocaleFromJDK8to6(Locale origialLocale) {
        try {
            origialLocale.hashCode();
            return origialLocale;
        }
        catch (Exception e) {
            return EcpI18nUtil.getDefaultGlobalLocale();
        }
    }

    public static boolean isJDK8Locale(Locale locale) {
        Field baseLocaleField = ClassUtil.getClassField(Locale.class, "baseLocale");
        Object baseLocale = ClassUtil.getAttribute(locale, "baseLocale");
        return baseLocaleField != null && baseLocale == null || locale.getLanguage() == null;
    }

    public static Locale getLoginLocale() {
        Locale locale = LogContextHolder.INSTANCE.getLocale();
        try {
            locale.hashCode();
            return locale;
        }
        catch (Exception e) {
            return EcpI18nUtil.getDefaultGlobalLocale();
        }
    }

    public static String localizedString(String key, String content) {
        return EcpI18nUtil.getMessage(key, content);
    }

    public static String localizedString(String key, String content, Object ... params) {
        if (StringUtils.isEmpty((String)key)) {
            return content;
        }
        return MessageFormat.format(EcpI18nUtil.localizedString(key, content), params);
    }

    public static String localizedStringBatch(String template, String content) {
        if (StringUtils.isEmpty((String)template)) {
            return content;
        }
        String res = EcpService.getI18nResourceService().getI18nResourceMessageBatch(template);
        if (StringUtils.isEmpty((String)res)) {
            return template;
        }
        return res;
    }

    public static String localizedDate(Date date, int dateStyle) {
        DateFormat dateFormatter = DateFormat.getDateInstance(dateStyle, LogContextHolder.INSTANCE.getLocale());
        return dateFormatter.format(date);
    }

    public static String localizedTime(Date time, int timeStyle) {
        DateFormat timeFormatter = DateFormat.getTimeInstance(timeStyle, LogContextHolder.INSTANCE.getLocale());
        return timeFormatter.format(time);
    }

    public static String localizedDateTime(Date date, int dateStyle, int timeStyle) {
        Locale locale = LogContextHolder.INSTANCE.getLocale();
        DateFormat dateTimeFormatter = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        return dateTimeFormatter.format(date);
    }

    public static String localizedInteger(int number) {
        return NumberFormat.getIntegerInstance(LogContextHolder.INSTANCE.getLocale()).format(number);
    }

    public static String localizedNumber(double number) {
        return NumberFormat.getNumberInstance(LogContextHolder.INSTANCE.getLocale()).format(number);
    }

    private static String getMessage(String key, String content) {
        if (StringUtils.isEmpty((String)key)) {
            return content;
        }
        String res = EcpService.getI18nResourceService().getExceptionResourceMessage(key);
        if (StringUtils.isEmpty((String)res)) {
            return content;
        }
        return res;
    }

    public static <V extends IValueObject> V getResourceMessage(V dataModel, String uri) {
        return EcpService.getI18nResourceService().getResourceMessage(dataModel, uri);
    }

    public static <V extends IValueObject> V getResourceMessage(Locale locale, V model, String uri) {
        return EcpService.getI18nResourceService().getResourceMessage(locale, model, uri);
    }

    public static String localizedStringByDB(String chName) {
        return EcpI18nUtil.localizedStringByDB(LogContextHolder.INSTANCE.getLocale(), chName);
    }

    public static List<String> localizedStringByDB(List<String> chNames) {
        return EcpI18nUtil.localizedStringByDB(LogContextHolder.INSTANCE.getLocale(), chNames);
    }

    public static Map<String, String> localizedListStringByDB(List<String> chNames) {
        return EcpI18nUtil.localizedListStringByDB(LogContextHolder.INSTANCE.getLocale(), chNames);
    }

    public static String localizedStringByDB(String localeStr, String chName) {
        return EcpI18nUtil.localizedStringByDB(I18nUtil.getLocale(localeStr), chName);
    }

    public static List<String> localizedStringByDB(String localeStr, List<String> chNames) {
        return EcpI18nUtil.localizedStringByDB(I18nUtil.getLocale(localeStr), chNames);
    }

    public static Map<String, String> localizedListString(String localeStr, List<String> chNames) {
        return EcpI18nUtil.localizedListStringByDB(I18nUtil.getLocale(localeStr), chNames);
    }

    public static String localizedStringByDB(Locale locale, String chName) {
        return EcpI18nUtil.localizedStringByDB(null, locale, chName);
    }

    public static List<String> localizedStringByDB(Locale locale, List<String> chNames) {
        return EcpI18nUtil.localizedStringByDB(null, locale, chNames);
    }

    public static Map<String, String> localizedListStringByDB(Locale locale, List<String> chNames) {
        return EcpI18nUtil.localizedListStringByDB(null, locale, chNames);
    }

    public static String localizedStringByDB(String schema, String localeStr, String chName) {
        Locale locale = I18nUtil.getLocale(localeStr);
        if (locale != null) {
            return EcpI18nUtil.localizedStringByDB(schema, locale, chName);
        }
        return null;
    }

    public static List<String> localizedStringByDB(String schema, String localeStr, List<String> chNames) {
        Locale locale = I18nUtil.getLocale(localeStr);
        if (locale != null) {
            return EcpI18nUtil.localizedStringByDB(schema, locale, chNames);
        }
        return null;
    }

    public static Map<String, String> localizedListStringByDB(String schema, String localeStr, List<String> chNames) {
        Locale locale = I18nUtil.getLocale(localeStr);
        if (locale != null) {
            return EcpI18nUtil.localizedListStringByDB(schema, localeStr, chNames);
        }
        return null;
    }

    public static String localizedStringByDB(String schema, Locale locale, String chName) {
        return EcpService.getI18nResourceService().localizedStringByDB(schema, locale, chName);
    }

    public static List<String> localizedStringByDB(String schema, Locale locale, List<String> chNames) {
        return EcpService.getI18nResourceService().localizedStringByDB(schema, locale, chNames);
    }

    public static Map<String, String> localizedListStringByDB(String schema, Locale locale, List<String> chNames) {
        return EcpService.getI18nResourceService().localizedListStringByDB(schema, locale, chNames);
    }

    public static boolean updateLocalizedString(String chName, String translatedStr) {
        return EcpI18nUtil.updateLocalizedString(LogContextHolder.INSTANCE.getLocale(), chName, translatedStr);
    }

    public static boolean updateLocalizedString(String localeStr, String chName, String translatedStr) {
        return EcpI18nUtil.updateLocalizedString(I18nUtil.getLocale(localeStr), chName, translatedStr);
    }

    public static boolean updateLocalizedString(Locale locale, String chName, String translatedStr) {
        return EcpI18nUtil.updateLocalizedString(null, locale, chName, translatedStr);
    }

    public static boolean updateLocalizedString(String schema, Locale locale, String chName, String translatedStr) {
        return EcpService.getI18nResourceService().updateLocalizedString(schema, locale, chName, translatedStr);
    }

    public static boolean updateLocalizedString(String schema, String localeStr, String chName, String translatedStr) {
        Locale locale = I18nUtil.getLocale(localeStr);
        if (locale != null) {
            return EcpI18nUtil.updateLocalizedString(schema, locale, chName, translatedStr);
        }
        return false;
    }

    public static boolean insertLocalizedString(String chName, String translatedStr) {
        return EcpI18nUtil.insertLocalizedString(LogContextHolder.INSTANCE.getLocale(), chName, translatedStr);
    }

    public static boolean insertLocalizedString(String localeStr, String chName, String translatedStr) {
        return EcpI18nUtil.insertLocalizedString(I18nUtil.getLocale(localeStr), chName, translatedStr);
    }

    public static boolean insertLocalizedString(Locale locale, String chName, String translatedStr) {
        return EcpI18nUtil.insertLocalizedString(null, locale, chName, translatedStr);
    }

    public static boolean insertLocalizedString(String schema, Locale locale, String chName, String translatedStr) {
        return EcpService.getI18nResourceService().insertLocalizedString(schema, locale, chName, translatedStr);
    }

    public static boolean insertLocalizedString(String schema, String localeStr, String chName, String translatedStr) {
        Locale locale = I18nUtil.getLocale(localeStr);
        if (locale != null) {
            return EcpI18nUtil.insertLocalizedString(schema, locale, chName, translatedStr);
        }
        return false;
    }

    public static boolean deleteLocalizedString(String chName) {
        return EcpI18nUtil.deleteLocalizedString(LogContextHolder.INSTANCE.getLocale(), chName);
    }

    public static boolean deleteLocalizedString(String localeStr, String chName) {
        return EcpI18nUtil.deleteLocalizedString(I18nUtil.getLocale(localeStr), chName);
    }

    public static boolean deleteLocalizedString(Locale locale, String chName) {
        return EcpI18nUtil.deleteLocalizedString(null, locale, chName);
    }

    public static boolean deleteLocalizedString(String schema, Locale locale, String chName) {
        return EcpService.getI18nResourceService().deleteLocalizedString(schema, locale, chName);
    }

    public static boolean deleteLocalizedString(String schema, String localeStr, String chName) {
        Locale locale = I18nUtil.getLocale(localeStr);
        if (locale != null) {
            return EcpI18nUtil.deleteLocalizedString(schema, locale, chName);
        }
        return false;
    }

    public static boolean existsLocalizedString(String chName) {
        return EcpI18nUtil.existsLocalizedString(null, LogContextHolder.INSTANCE.getLocale(), chName);
    }

    public static boolean existsLocalizedString(Locale locale, String chName) {
        return EcpI18nUtil.existsLocalizedString(null, locale, chName);
    }

    public static boolean existsLocalizedString(String localeStr, String chName) {
        return EcpI18nUtil.existsLocalizedString(null, localeStr, chName);
    }

    public static boolean existsLocalizedString(String schema, String localeStr, String chName) {
        return EcpI18nUtil.existsLocalizedString(schema, I18nUtil.getLocale(localeStr), chName);
    }

    public static boolean existsLocalizedString(String schema, Locale locale, String chName) {
        if (locale != null) {
            return EcpService.getI18nResourceService().existsLocalizedString(schema, locale, chName);
        }
        return false;
    }

    public static Map<String, Map<String, Object>> getResMap() {
        return EcpService.getI18nResourceService().getResMap();
    }

    public static Map<String, Map<String, Object>> getResConfigMap() {
        return EcpService.getI18nResourceService().getResConfigMap();
    }

    public static ICache<String, String> getDBResourceCache() {
        return EcpService.getI18nResourceService().getDBResourceCache();
    }

    public static int getLangIdByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return -1;
        }
        return EcpService.getI18nResourceService().getLangIdByCode(code);
    }

    public static boolean isNeedTranslate() {
        Locale locale = LogContextHolder.INSTANCE.getLocale();
        String localeStr = I18nUtil.getLocaleStr(locale);
        return !StringUtils.equals((String)localeStr, (String)"zh_CN");
    }

    public static String getLocale() {
        Locale locale = LogContextHolder.INSTANCE.getLocale();
        return I18nUtil.getLocaleStr(locale);
    }

    public static Map<String, String> getSupportedLangs() {
        return I18nConfig.getInstance().getLangMap();
    }

    public static void clearDBResourceCache() {
        DBResourceAccessService.clearResource();
    }
}

