/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.model.EnumItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumUtil {
    private static Map<Class<?>, Object> map = new ConcurrentHashMap();

    private EnumUtil() {
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, int ordinal) {
        try {
            Object[] values = (Object[])map.get(enumType);
            if (values == null) {
                Method method = enumType.getMethod("values", new Class[0]);
                values = (Object[])method.invoke(null, new Object[0]);
                map.put(enumType, values);
            }
            Enum e = null;
            for (Object value : values) {
                e = (Enum)value;
                if (e.ordinal() != ordinal) continue;
                return (T)e;
            }
            return (T)((Enum)null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Enum<T>> EnumItem[] getEnumItem(Class<T> enumClass) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        Field captionsField = ClassUtil.getClassFieldIncludeSuperClass(enumClass, "CAPTIONS", Enum.class);
        EnumItem[] items = new EnumItem[values.length];
        if (captionsField != null) {
            try {
                String[] captions = (String[])captionsField.get(null);
                items = new EnumItem[values.length];
                int i = 0;
                int ordinal = 0;
                int length = captions.length;
                for (Enum item : values) {
                    ordinal = item.ordinal();
                    items[i++] = ordinal < length ? new EnumItem(ordinal, item.name(), captions[ordinal]) : new EnumItem(ordinal, item.name(), captions[length - 1]);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            String[] captions = EnumUtil.getEnumCaptions(enumClass);
            if (captions != null) {
                items = new EnumItem[values.length];
                int i = 0;
                int ordinal = 0;
                int length = captions.length;
                for (Enum item : values) {
                    ordinal = item.ordinal();
                    items[i++] = ordinal < length ? new EnumItem(ordinal, item.name(), captions[ordinal]) : new EnumItem(ordinal, item.name(), captions[length - 1]);
                }
            } else {
                items = new EnumItem[values.length];
                int i = 0;
                int ordinal = 0;
                for (Enum item : values) {
                    ordinal = item.ordinal();
                    items[i++] = new EnumItem(ordinal, item.name(), item.name());
                }
            }
        }
        return items;
    }

    public static String[] getEnumCaptions(Class<?> cls) {
        String captions = EcpService.getI18nResourceService().getI18nResourceMessage(cls.getName());
        String[] result = null;
        if (captions != null) {
            String[] captionsArray = captions.split(",");
            result = new String[captionsArray.length];
            String str = null;
            int pos = 0;
            for (int i = 0; i < captionsArray.length; ++i) {
                str = captionsArray[i];
                pos = str.indexOf(58);
                result[i] = pos >= 0 ? str.substring(pos + 1) : str;
            }
        }
        return result;
    }
}

