/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.executor.DefaultServiceMessage;
import com.ygsoft.ecp.service.executor.LocalServiceMessage;
import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.executor.engine.DefaultServiceDispatcher;
import com.ygsoft.ecp.service.executor.engine.DefaultServiceFilter;
import com.ygsoft.ecp.service.executor.engine.DefaultServiceHandler;
import com.ygsoft.ecp.service.executor.engine.LocalServiceHandler;
import com.ygsoft.ecp.service.executor.engine.ServiceExecution;
import com.ygsoft.ecp.service.executor.engine.ServiceExecutorFactory;
import com.ygsoft.ecp.service.executor.engine.ServiceFilter;
import com.ygsoft.ecp.service.executor.engine.ServiceHandler;
import com.ygsoft.ecp.service.executor.engine.SessionServiceFilter;
import com.ygsoft.ecp.service.executor.engine.SingleServiceExecutor;
import com.ygsoft.ecp.service.executor.engine.WebServiceHandler;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.support.AopUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutorUtil
implements IEcpToolLogic {
    private static final DefaultServiceHandler HANDLER = new DefaultServiceHandler();
    private static final ServiceFilter LOG_FILTER = new DefaultServiceFilter();
    private static final ServiceHandler LOCAL_HANDLER = new LocalServiceHandler();
    private static final ServiceHandler WEBSERVICE_HANDLER = new WebServiceHandler();
    private static final DefaultServiceDispatcher DISPATCHER = new DefaultServiceDispatcher();
    private static final DefaultServiceDispatcher SERVICEDISPATCHER = new DefaultServiceDispatcher();
    private static final Map<String, ServiceHandler> HANDLERS = new HashMap<String, ServiceHandler>();
    private static final SingleServiceExecutor EXECUTOR = new SingleServiceExecutor();
    private static final List<ServiceFilter> FILTERS = new ArrayList<ServiceFilter>();

    private ExecutorUtil() {
    }

    public static Object asyExecuteRemoteService(String serviceCode, String serviceName, Object[] paramers) {
        ServiceMessage result = DISPATCHER.dispatch(ExecutorUtil.buildRemoteServiceMessage(serviceCode, serviceName, paramers));
        return result.getContent();
    }

    public static Object asyExecuteRemoteServiceNoBlock(String serviceCode, String serviceName, Object[] paramers) {
        ServiceMessage serviceMessage = ExecutorUtil.buildRemoteServiceMessage(serviceCode, serviceName, paramers);
        serviceMessage.set("true", "false");
        ServiceMessage result = DISPATCHER.dispatch(serviceMessage);
        return result.getContent();
    }

    public static Object asyExecuteRemoteServiceBySidNoBlock(String serviceCode, String serviceName, Object[] paramers, String sid) {
        ServiceMessage serviceMessage = ExecutorUtil.buildRemoteServiceMessage(serviceCode, serviceName, paramers);
        serviceMessage.set("true", "false");
        serviceMessage.set("SERVICE_EXECUTE_ID", sid);
        ServiceMessage result = DISPATCHER.dispatch(serviceMessage);
        return result.getContent();
    }

    public static Object asyExecuteLocalService(String interfaceName, String methodName, Object[] paramers) {
        if (SessionServiceFilter.isGap()) {
            return ExecutorUtil.asyExecuteLocalServiceWithGAP(interfaceName, methodName, paramers);
        }
        return ExecutorUtil.asyExecuteLocalServiceWithECP(interfaceName, methodName, paramers);
    }

    public static Object asyExecuteLocalServiceNoBlock(String interfaceName, String methodName, Object[] paramers) {
        if (SessionServiceFilter.isGap()) {
            return ExecutorUtil.asyExecuteLocalServiceWithGAPNoBlock(interfaceName, methodName, paramers);
        }
        return ExecutorUtil.asyExecuteLocalServiceWithECPNoBlock(interfaceName, methodName, paramers);
    }

    public static Object asyExecuteLocalServiceBySidNoBlock(String interfaceName, String methodName, Object[] paramers, String sid) {
        if (SessionServiceFilter.isGap()) {
            return ExecutorUtil.asyExecuteLocalServiceWithGAPBySidNoBlock(interfaceName, methodName, paramers, sid);
        }
        return ExecutorUtil.asyExecuteLocalServiceWithECPBySidNoBlock(interfaceName, methodName, paramers, sid);
    }

    public static Object asyExecuteLocalServiceWithoutSession(String interfaceName, String methodName, Object[] paramers) {
        ServiceMessage result = DISPATCHER.dispatch(ExecutorUtil.buildLocalServiceMessage(interfaceName, methodName, paramers));
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithECP(String interfaceName, String methodName, Object[] paramers) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(interfaceName, methodName, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithECPNoBlock(String interfaceName, String methodName, Object[] paramers) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(interfaceName, methodName, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("true", "false");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithECPBySidNoBlock(String interfaceName, String methodName, Object[] paramers, String sid) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(interfaceName, methodName, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("true", "false");
        message.set("SERVICE_EXECUTE_ID", sid);
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithECPBySidNoBlock(Object object, Method method, Object[] paramers, String sid) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(object, method, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("true", "false");
        message.set("SERVICE_EXECUTE_ID", sid);
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithGAPNoBlock(String interfaceName, String methodName, Object[] paramers) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(interfaceName, methodName, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("true", "false");
        message.set("GAP_FLAG", "GAP");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithGAPBySidNoBlock(String interfaceName, String methodName, Object[] paramers, String sid) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(interfaceName, methodName, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("true", "false");
        message.set("SERVICE_EXECUTE_ID", sid);
        message.set("GAP_FLAG", "GAP");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithGAP(String interfaceName, String methodName, Object[] paramers) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(interfaceName, methodName, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("GAP_FLAG", "GAP");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithoutSession(Object object, Method method, Object[] paramers) {
        ServiceMessage result = DISPATCHER.dispatch(ExecutorUtil.buildLocalServiceMessage(object, method, paramers));
        return result.getContent();
    }

    public static Object asyExecuteLocalService(Object object, Method method, Object[] paramers) {
        if (SessionServiceFilter.isGap()) {
            return ExecutorUtil.asyExecuteLocalServiceWithGAP(object, method, paramers);
        }
        return ExecutorUtil.asyExecuteLocalServiceWithECP(object, method, paramers);
    }

    public static Object asyExecuteLocalServiceNoBlock(Object object, Method method, Object[] paramers) {
        if (SessionServiceFilter.isGap()) {
            return ExecutorUtil.asyExecuteLocalServiceWithGAPNoBlock(object, method, paramers);
        }
        return ExecutorUtil.asyExecuteLocalServiceWithECPNoBlock(object, method, paramers);
    }

    public static Object asyExecuteLocalServiceWithECP(Object object, Method method, Object[] paramers) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(object, method, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithECPNoBlock(Object object, Method method, Object[] paramers) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(object, method, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("true", "false");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithGAPNoBlock(Object object, Method method, Object[] paramers) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(object, method, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("true", "false");
        message.set("GAP_FLAG", "GAP");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteLocalServiceWithGAP(Object object, Method method, Object[] paramers) {
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(object, method, paramers);
        message.set("SESSION_FILTER_FLAG", "true");
        message.set("GAP_FLAG", "GAP");
        SessionServiceFilter.buildSessionAndDataBus(message);
        ServiceMessage result = DISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object asyExecuteWithoutSession(Class<? extends Object> cls, String methodName, Object[] paramers) {
        return ExecutorUtil.asyExecuteWithoutSession(cls, methodName, paramers, 3600);
    }

    public static Object asyExecuteWithoutSession(Class<? extends Object> cls, String methodName, Object[] paramers, int timeout) {
        try {
            if (cls.isInterface()) {
                return ServiceExecutorFactory.createExecutor().execute(ExecutorUtil.buildServiceMessage(cls, methodName, paramers), timeout, LOCAL_HANDLER).getContent();
            }
            return ServiceExecutorFactory.createExecutor().execute(ExecutorUtil.buildServiceMessage(cls, methodName, paramers), timeout, HANDLER).getContent();
        }
        catch (Exception e) {
            throw new EcpRuntimeException("service dispatching error", e);
        }
    }

    public static Object asyExecute(Class<? extends Object> cls, String methodName, Object[] paramers) {
        return ExecutorUtil.asyExecute(cls, methodName, paramers, 3600);
    }

    public static Object asyExecute(Class<? extends Object> cls, String methodName, Object[] paramers, int timeout) {
        try {
            if (cls.isInterface()) {
                ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(cls.getName(), methodName, paramers);
                message.set("SESSION_FILTER_FLAG", "true");
                SessionServiceFilter.buildSessionAndDataBus(message);
                if (SessionServiceFilter.isGap()) {
                    message.set("GAP_FLAG", "GAP");
                }
                return ServiceExecutorFactory.createExecutor().execute(message, timeout, LOCAL_HANDLER).getContent();
            }
            ServiceMessage message = ExecutorUtil.buildServiceMessage(cls, methodName, paramers);
            message.set("SESSION_FILTER_FLAG", "true");
            if (SessionServiceFilter.isGap()) {
                message.set("GAP_FLAG", "GAP");
            }
            return ServiceExecutorFactory.createExecutor().execute(message, timeout, HANDLER).getContent();
        }
        catch (Exception e) {
            throw new EcpRuntimeException("service dispatching error", e);
        }
    }

    public static ServiceMessage asyExecute(ServiceMessage message, ServiceHandler serviceHandler) {
        return ExecutorUtil.asyExecute(message, serviceHandler, 3600);
    }

    public static ServiceMessage asyExecute(ServiceMessage message, ServiceHandler serviceHandler, int timeout) {
        try {
            return ServiceExecutorFactory.createExecutor().execute(message, timeout, serviceHandler);
        }
        catch (Exception e) {
            throw new EcpRuntimeException("service dispatching error", e);
        }
    }

    public static Object synExecute(Class<? extends Object> cls, String methodName, Object[] paramers) {
        if (cls.isInterface()) {
            return ExecutorUtil.synExecute(cls.getName(), methodName, paramers);
        }
        SERVICEDISPATCHER.setServiceExecutor(EXECUTOR);
        SERVICEDISPATCHER.setServiceHandlers(HANDLERS);
        SERVICEDISPATCHER.setFilters(FILTERS);
        ServiceMessage message = ExecutorUtil.buildServiceMessage(cls, methodName, paramers);
        ServiceMessage result = SERVICEDISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object synExecute(Object object, Method method, Object[] paramers) {
        SERVICEDISPATCHER.setServiceExecutor(EXECUTOR);
        SERVICEDISPATCHER.setServiceHandlers(HANDLERS);
        SERVICEDISPATCHER.setFilters(FILTERS);
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(object, method, paramers);
        ServiceMessage result = SERVICEDISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object synExecute(String interfaceName, String methodName, Object[] paramers) {
        SERVICEDISPATCHER.setServiceExecutor(EXECUTOR);
        SERVICEDISPATCHER.setServiceHandlers(HANDLERS);
        SERVICEDISPATCHER.setFilters(FILTERS);
        ServiceMessage message = ExecutorUtil.buildLocalServiceMessage(interfaceName, methodName, paramers);
        ServiceMessage result = SERVICEDISPATCHER.dispatch(message);
        return result.getContent();
    }

    public static Object synExecuteRemoteService(String serviceCode, String serviceName, Object[] paramers) {
        SERVICEDISPATCHER.setServiceExecutor(EXECUTOR);
        SERVICEDISPATCHER.setServiceHandlers(HANDLERS);
        SERVICEDISPATCHER.setFilters(FILTERS);
        ServiceMessage message = ExecutorUtil.buildRemoteServiceMessage(serviceCode, serviceName, paramers);
        ServiceMessage result = SERVICEDISPATCHER.dispatch(message);
        return result.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object synExecuteWithFilter(Class<? extends Object> cls, String methodName, Object[] paramers, List<ServiceFilter> filters) {
        try {
            ServiceMessage message = null;
            message = cls.isInterface() ? ExecutorUtil.buildLocalServiceMessage(cls.getName(), methodName, paramers) : ExecutorUtil.buildServiceMessage(cls, methodName, paramers);
            SERVICEDISPATCHER.setServiceExecutor(EXECUTOR);
            SERVICEDISPATCHER.setServiceHandlers(HANDLERS);
            SERVICEDISPATCHER.setFilters(filters);
            ServiceMessage result = SERVICEDISPATCHER.dispatch(message);
            Object object = result.getContent();
            Object var8_7 = null;
            SERVICEDISPATCHER.setFilters(null);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SERVICEDISPATCHER.setFilters(null);
            throw throwable;
        }
    }

    public static ServiceMessage buildRemoteServiceMessage(String serviceCode, String serviceName, Object[] paramers) {
        DefaultServiceMessage message = new DefaultServiceMessage();
        message.setServiceCode(serviceCode);
        message.setServiceName(serviceName);
        message.setParameters(paramers);
        message.setServiceType("remote");
        return message;
    }

    public static ServiceMessage buildLocalServiceMessage(Object object, Method method, Object[] paramers) {
        LocalServiceMessage message = new LocalServiceMessage();
        message.setObject(object);
        message.setMethod(method);
        message.setParameters(paramers);
        if (AopUtils.isAopProxy((Object)object)) {
            message.setServiceCode(AopUtils.getTargetClass((Object)object).getName());
        } else {
            message.setServiceCode(object.getClass().getName());
        }
        message.setServiceName(method.getName());
        message.setServiceType("local");
        return message;
    }

    public static ServiceMessage buildLocalServiceMessage(String interfaceName, String methodName, Object[] paramers) {
        DefaultServiceMessage message = new DefaultServiceMessage();
        message.setServiceCode(interfaceName);
        message.setServiceName(methodName);
        message.setParameters(paramers);
        message.setServiceType("local");
        return message;
    }

    public static List<ServiceMessage> getPendingServiceMessage() {
        List<ServiceExecution> serviceExecutions = ServiceExecutorFactory.createExecutor().getPendingExecutions();
        if (serviceExecutions != null && !serviceExecutions.isEmpty()) {
            ArrayList<ServiceMessage> serviceMessages = new ArrayList<ServiceMessage>(serviceExecutions.size());
            for (ServiceExecution serviceExecution : serviceExecutions) {
                serviceMessages.add(serviceExecution.getMessage());
            }
            return serviceMessages;
        }
        return Collections.emptyList();
    }

    public static boolean cancellExecution(ServiceMessage serviceMessage) {
        return ExecutorUtil.cancellExecution(serviceMessage.hashCode());
    }

    public static boolean cancellExecution(int executionId) {
        return ServiceExecutorFactory.createExecutor().cancellExecution(executionId);
    }

    public static boolean cancellExecution(String serviceCode, String serviceName) {
        boolean flag = true;
        List<ServiceMessage> pendingServiceMessages = ExecutorUtil.getPendingServiceMessage();
        for (ServiceMessage serviceMessage : pendingServiceMessages) {
            if (!StringUtil.isEquals(serviceCode, serviceMessage.getServiceCode()) || !StringUtil.isEquals(serviceName, serviceMessage.getServiceName())) continue;
            flag = flag && ServiceExecutorFactory.createExecutor().cancellExecution(serviceMessage.hashCode());
        }
        return flag;
    }

    public static ServiceMessage buildServiceMessage(Class<? extends Object> cls, String methodName, Object[] paramers) {
        DefaultServiceMessage message = new DefaultServiceMessage();
        message.setServiceCode(cls.getName());
        message.setServiceName(methodName);
        message.setParameters(paramers);
        message.setServiceType("default");
        return message;
    }

    static {
        HANDLERS.put("default", HANDLER);
        HANDLERS.put("local", LOCAL_HANDLER);
        HANDLERS.put("remote", WEBSERVICE_HANDLER);
        FILTERS.add(LOG_FILTER);
        DISPATCHER.setFilters(FILTERS);
        DISPATCHER.setServiceHandlers(HANDLERS);
        DISPATCHER.setServiceExecutor(ServiceExecutorFactory.createExecutor());
    }
}

