/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.cons.NumberConst;
import com.ygsoft.ecp.service.dataaccess.IEntityMetadataService;
import com.ygsoft.ecp.service.dataaccess.IHibernateTemplate;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.executor.SoftLimitMRUCache;
import com.ygsoft.ecp.service.internal.tool.HTTPServiceProxy;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.exception.FindException;
import com.ygsoft.ecp.service.tool.exception.ParamCheckException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.scannotation.AnnotationDB;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OSGiUtil
implements ApplicationContextAware,
IEcpToolLogic {
    private static final SoftLimitMRUCache<String, Object> CACHE = new SoftLimitMRUCache(NumberConst.HUNDRED * NumberConst.HUNDRED);
    private static final String DEFAULT_BUNDLENAME = "com.ygsoft.ecp.service.security.impl";
    private static final IEcpLog LOG = EcpLogFactory.getLog(OSGiUtil.class);
    private static final Object NULL_OBJECT = new Object();
    private static final String ECP_SESSIONFACTORY = "ECPSessionFactory";
    private static final String ECP_METADATASERVICE = "ECPMetadataService";
    public static Class osigSimulatorclazz = null;
    private static Class<?> springUtilCls = null;
    private static Method invokeMethod = null;
    private static final Map<String, ListableBeanFactory> BEAN_FACTORY_CACHE;
    private static ApplicationContext applicationContext;

    public static Method getInvokeServiceFilterMethod() {
        if (null == invokeMethod) {
            invokeMethod = ClassUtil.getMethod(springUtilCls, "getServiceByOSGiServiceFilter", new Class[]{Object.class, String.class});
        }
        return invokeMethod;
    }

    private OSGiUtil() {
    }

    public static Object getService(BundleContext bundleContext, String interfaceName) {
        if (bundleContext == null) {
            return OSGiUtil.getSpringBean(interfaceName);
        }
        if (StringUtil.isEmptyString(interfaceName)) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "bundleContext\u4e0d\u80fd\u4e3a\u7a7a \u6216 \u63a5\u53e3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        String key = bundleContext.getBundle().getSymbolicName() + "_" + interfaceName;
        if (CACHE.containsKey(key)) {
            Object proxy = CACHE.get(key);
            return NULL_OBJECT.equals(proxy) ? null : proxy;
        }
        Object value = null;
        ServiceReference serviceReference = bundleContext.getServiceReference(interfaceName);
        if (serviceReference != null) {
            value = bundleContext.getService(serviceReference);
            if (value != null) {
                CACHE.put(key, value);
            }
        } else if (RuntimeEnvUtil.INSTANCE.getRemoteServiceHost() != null && RuntimeEnvUtil.INSTANCE.isOsgiServerStarted()) {
            try {
                String host = HTTPServiceProxy.getRemoteHost(interfaceName);
                if (host != null) {
                    Class cls = ClassUtil.getClass(interfaceName);
                    HTTPServiceProxy proxy = new HTTPServiceProxy(host);
                    value = proxy.bind(cls);
                    CACHE.put(key, value);
                } else {
                    CACHE.put(key, NULL_OBJECT);
                }
            }
            catch (Exception e) {
                throw new EcpRuntimeException("E0208.0024", EcpI18nUtil.localizedString("E0208.0024", "\u670d\u52a1\u67e5\u627e\u5f02\u5e38"), e, new Object[0]);
            }
        }
        return value;
    }

    public static List<Object> getServices(BundleContext bundleContext, String interfaceName) {
        return OSGiUtil.getServicesByFilter(bundleContext, interfaceName, null);
    }

    public static List<Object> getServices(String interfaceName) {
        return OSGiUtil.getServicesByFilter(OSGiUtil.findDefaultBundle(), interfaceName, null);
    }

    public static Object getServiceByFilter(BundleContext bundleContext, String interfaceName, String filters) {
        if (StringUtil.isEmptyString(filters)) {
            return OSGiUtil.getService(bundleContext, interfaceName);
        }
        if (bundleContext == null) {
            try {
                Class clazz = ClassUtil.getClass(interfaceName);
                Method synMethod = OSGiUtil.getInvokeServiceFilterMethod();
                if (synMethod != null) {
                    synMethod.setAccessible(true);
                    return synMethod.invoke(null, clazz, filters);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return OSGiUtil.getSpringBean(interfaceName);
        }
        if (StringUtil.isEmptyString(interfaceName)) {
            throw new ParamCheckException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "bundleContext\u4e0d\u80fd\u4e3a\u7a7a \u6216 \u63a5\u53e3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return null;
    }

    public static List<Object> getServicesByFilter(BundleContext bundleContext, String interfaceName, String filters) {
        String key;
        if (bundleContext == null || StringUtil.isEmptyString(interfaceName)) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object object = OSGiUtil.getSpringBean(interfaceName);
            list.add(object);
            return list;
        }
        String filterName = "_";
        if (filters == null) {
            filterName = filterName + filters;
        }
        if (CACHE.containsKey(key = bundleContext.getBundle().getSymbolicName() + "_" + interfaceName + filterName)) {
            Object proxy;
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u4ece\u9ad8\u901f\u7f13\u5b58\u83b7\u53d6\u670d\u52a1filter\u5b9e\u73b0..." + key);
            }
            if (NULL_OBJECT.equals(proxy = CACHE.get(key))) {
                return Collections.emptyList();
            }
            return (List)proxy;
        }
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = filters == null ? bundleContext.getAllServiceReferences(interfaceName, null) : bundleContext.getServiceReferences(interfaceName, filters);
        }
        catch (InvalidSyntaxException e) {
            throw new ParamCheckException("E0208.0024", EcpI18nUtil.localizedString("E0208.0024", "\u670d\u52a1\u67e5\u627e\u51fa\u73b0\u5f02\u5e38"));
        }
        if (serviceReferences != null && serviceReferences.length > 0) {
            ArrayList<Object> services = new ArrayList<Object>();
            for (ServiceReference serviceReference : serviceReferences) {
                services.add(bundleContext.getService(serviceReference));
            }
            CACHE.put(key, services);
            return services;
        }
        CACHE.put(key, NULL_OBJECT);
        return Collections.emptyList();
    }

    public static <T> T getService(BundleContext bundleContext, Class<T> interfaceClass) {
        return (T)OSGiUtil.getService(bundleContext, interfaceClass.getName());
    }

    public static <T> List<T> getServices(Class<T> interfaceClass) {
        return OSGiUtil.getServices(OSGiUtil.findDefaultBundle(), interfaceClass);
    }

    public static <T> List<T> getServices(BundleContext bundleContext, Class<T> interfaceClass) {
        return OSGiUtil.getServices(bundleContext, interfaceClass.getName());
    }

    private static ListableBeanFactory getSpringBeanFactory(BundleContext bundleContext) {
        try {
            String bundleName = bundleContext.getBundle().getSymbolicName();
            if (bundleName != null && BEAN_FACTORY_CACHE.containsKey(bundleName)) {
                return BEAN_FACTORY_CACHE.get(bundleName);
            }
            ServiceReference[] serviceReferences = bundleContext.getServiceReferences(ListableBeanFactory.class.getName(), "(Bundle-SymbolicName=" + bundleName + ")");
            if (serviceReferences != null && serviceReferences.length > 0) {
                ListableBeanFactory beanFactory = (ListableBeanFactory)bundleContext.getService(serviceReferences[0]);
                if (beanFactory != null) {
                    BEAN_FACTORY_CACHE.put(bundleName, beanFactory);
                }
                return beanFactory;
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getSpringBean(String beanId) {
        try {
            if (StringUtil.isNotEmpty(beanId)) {
                if (ISQLTemplate.class.getName().equals(beanId) || IHibernateTemplate.class.getName().equals(beanId)) {
                    return OSGiUtil.getApplicationContext().getBean(ECP_SESSIONFACTORY);
                }
                if (IEntityMetadataService.class.getName().equals(beanId)) {
                    return OSGiUtil.getApplicationContext().getBean(ECP_METADATASERVICE);
                }
                if (beanId.indexOf(".") != -1) {
                    Class clazz = ClassUtil.getClass(beanId);
                    return OSGiUtil.getSpringBean(clazz);
                }
                return OSGiUtil.getApplicationContext().getBean(beanId);
            }
            return null;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Spring beanId [" + beanId + "] not found");
            }
            return null;
        }
    }

    public static Object getSpringBean(BundleContext bundleContext, String beanId) {
        try {
            ListableBeanFactory beanFactory = OSGiUtil.getSpringBeanFactory(bundleContext);
            if (beanFactory != null) {
                return beanFactory.getBean(beanId);
            }
            return null;
        }
        catch (Exception e) {
            throw new FindException("E0208.0023", e);
        }
    }

    public static <T> T getSpringBean(Class<T> clazz) {
        Object bean;
        block3: {
            String className = clazz.getSimpleName();
            String beanId = clazz.isInterface() && className.charAt(0) == 'I' && Character.isUpperCase(className.charAt(1)) ? StringUtil.firstToLowerCase(className.substring(1)) : StringUtil.firstToLowerCase(className);
            ListableBeanFactory beanFactory = OSGiUtil.getSpringBeanFactory();
            bean = null;
            if (beanFactory != null) {
                try {
                    bean = beanFactory.getBean(beanId, clazz);
                }
                catch (BeansException e) {
                    Map beans = beanFactory.getBeansOfType(clazz);
                    if (beans.isEmpty()) break block3;
                    bean = beans.values().iterator().next();
                }
            }
        }
        return (T)bean;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext newApplicationContext) {
        applicationContext = newApplicationContext;
    }

    private static ListableBeanFactory getSpringBeanFactory() {
        return OSGiUtil.getApplicationContext();
    }

    public static <T> T getSpringBean(BundleContext bundleContext, Class<T> clazz) {
        Object bean;
        block3: {
            String className = clazz.getSimpleName();
            String beanId = clazz.isInterface() && className.charAt(0) == 'I' && Character.isUpperCase(className.charAt(1)) ? StringUtil.firstToLowerCase(className.substring(1)) : StringUtil.firstToLowerCase(className);
            ListableBeanFactory beanFactory = OSGiUtil.getSpringBeanFactory(bundleContext);
            bean = null;
            if (beanFactory != null) {
                try {
                    bean = beanFactory.getBean(beanId, clazz);
                }
                catch (BeansException e) {
                    Map beans = beanFactory.getBeansOfType(clazz);
                    if (beans.isEmpty()) break block3;
                    bean = beans.values().iterator().next();
                }
            }
        }
        return (T)bean;
    }

    public static Object getService(String interfaceName) {
        return OSGiUtil.getService(OSGiUtil.findDefaultBundle(), interfaceName);
    }

    public static <T> T getService(Class<T> interfaceClass) {
        BundleContext bundleContext = OSGiUtil.findDefaultBundle();
        Object retObj = null;
        if (bundleContext == null) {
            if ("com.ygsoft.ecp.component.unstructure.context.IEntityAttachmentContext".equals(interfaceClass.getName())) {
                return (T)OSGiUtil.getApplicationContext().getBean("osgiEntityAttachmentContext");
            }
            retObj = OSGiUtil.getSpringBean(interfaceClass);
            if (retObj == null) {
                retObj = OSGiUtil.getSpringBean(interfaceClass.getName());
            }
            return (T)retObj;
        }
        return (T)OSGiUtil.getService(OSGiUtil.findDefaultBundle(), interfaceClass.getName());
    }

    public static Object getServiceByFilter(String interfaceName, String filters) {
        return OSGiUtil.getServiceByFilter(OSGiUtil.findDefaultBundle(), interfaceName, filters);
    }

    public static <T> T getServiceByFilter(Class<T> interfaceClass, String filters) {
        return (T)OSGiUtil.getServiceByFilter(OSGiUtil.findDefaultBundle(), interfaceClass.getName(), filters);
    }

    public static <T> List<T> getServicesByFilter(Class<T> interfaceClass, String filters) {
        return OSGiUtil.getServicesByFilter(OSGiUtil.findDefaultBundle(), interfaceClass.getName(), filters);
    }

    public static File getBundleFile(Bundle bundle) {
        return new File(bundle.getEntry("/").getPath());
    }

    public static Bundle getBundle(String bundleName) {
        BundleContext bundleContext = OSGiUtil.findDefaultBundle();
        if (bundleContext != null && !StringUtil.isNullOrTrimEmptyString(bundleName)) {
            Bundle[] bundles;
            for (Bundle bundle : bundles = bundleContext.getBundles()) {
                if (bundle == null || bundle.getSymbolicName() == null || !bundle.getSymbolicName().equals(bundleName)) continue;
                return bundle;
            }
        }
        return null;
    }

    public static InputStreamReader getBunldeResourceReader(String bundleName, String path, String encoding) {
        Bundle bundle = OSGiUtil.getBundle(bundleName);
        if (bundle != null) {
            URL url = bundle.getResource(path);
            try {
                URLConnection connection = url.openConnection();
                if (connection.getContentType() == null) {
                    ClassUtil.setAttribute(connection, "contentType", "application/text;charset=" + encoding);
                }
                InputStream in = (InputStream)connection.getContent();
                return new InputStreamReader(in, encoding);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static BundleContext findDefaultBundle() {
        BundleContext bundleContext = null;
        if (osigSimulatorclazz != null) {
            bundleContext = (BundleContext)ClassUtil.callMethod(osigSimulatorclazz, "getBundle", new Object[]{DEFAULT_BUNDLENAME});
        }
        return bundleContext;
    }

    public static void clearOsgiServiceCache() {
        CACHE.clear();
        BEAN_FACTORY_CACHE.clear();
    }

    public static Set<Class<?>> serachInBundle(Bundle bundle, String[] scanPackages, Class<?>[] annotationClasses) {
        AnnotationDB annotationDB = new AnnotationDB();
        HashSet result = new HashSet();
        try {
            if (scanPackages != null && scanPackages.length > 0) {
                annotationDB.setScanPackages(scanPackages);
            }
            annotationDB.scanArchives(new URL[]{OSGiUtil.getBundleFile(bundle).toURL()});
            for (int i = 0; i < annotationClasses.length; ++i) {
                Set classNames = (Set)annotationDB.getAnnotationIndex().get(annotationClasses[i].getName());
                if (classNames == null) continue;
                for (String className : classNames) {
                    try {
                        result.add(bundle.loadClass(className));
                    }
                    catch (ClassNotFoundException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("\u83b7\u53d6\u7c7b\u5931\u8d25\uff01className\u4e3a" + className);
                        }
                        throw new FindException("E0208.0023", EcpI18nUtil.localizedString("E0208.0023", "\u83b7\u53d6\u7c7b\u5931\u8d25"), e, new Object[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("\u83b7\u53d6\u7c7b\u5931\u8d25\uff01bundle\u4e3a" + bundle.getSymbolicName());
            }
            e.printStackTrace();
        }
        return result;
    }

    static {
        try {
            osigSimulatorclazz = ClassUtil.forName("com.ygsoft.ecp.osgi.simulator.Framework");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            springUtilCls = ClassUtil.getClass("com.ygsoft.necp.core.service.tool.SpringUtil");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        BEAN_FACTORY_CACHE = new ConcurrentHashMap<String, ListableBeanFactory>(NumberConst.KB_INTEGER);
    }
}

