/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.cache.IGeneralRedisService;
import com.ygsoft.ecp.service.cache.IRedisService;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RedisUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(RedisUtil.class);
    private static IRedisService redisService;

    private RedisUtil() {
    }

    public static IRedisService getRedisService() {
        block6: {
            try {
                if (redisService != null) {
                    return redisService;
                }
                redisService = OSGiUtil.getService(IRedisService.class);
            }
            catch (Throwable e) {
                redisService = null;
            }
            if (redisService == null) {
                try {
                    redisService = (IRedisService)Class.forName("com.ygsoft.ecp.service.cache.impl.redis.RedisService").newInstance();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error(e.getMessage(), e);
                }
            }
        }
        return redisService;
    }

    public static IGeneralRedisService getGeneralRedisService() {
        IGeneralRedisService service;
        block2: {
            service = null;
            try {
                Class cls = ClassUtil.getClass("com.ygsoft.ecp.service.cache.impl.redis.GeneralRedisServiceImpl");
                Object obj = ClassUtil.createObject(cls, null);
                service = (IGeneralRedisService)obj;
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error(e.getMessage(), e);
            }
        }
        return service;
    }

    public static IRedisService getRedisService(String servers, String pwd) {
        String user = null;
        return RedisUtil.getRedisService(servers, user, pwd, false, false);
    }

    public static IRedisService getRedisService(String servers, String pwd, boolean sentinel, boolean useThreadCache) {
        return RedisUtil.getRedisService(servers, null, pwd, sentinel, useThreadCache);
    }

    public static IRedisService getRedisService(String servers, String userName, String pwd, boolean sentinel, boolean useThreadCache) {
        IRedisService service;
        block3: {
            service = null;
            try {
                if (StringUtil.isNotEmptyString(servers)) {
                    Class cls = ClassUtil.getClass("com.ygsoft.ecp.service.cache.impl.redis.RedisServiceImpl");
                    Object[] constructorParams = new Object[]{servers, userName, pwd, sentinel, useThreadCache};
                    Object obj = ClassUtil.createObject(cls, constructorParams);
                    service = (IRedisService)obj;
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error(e.getMessage(), e);
            }
        }
        return service;
    }

    public static <K, V> ICache<K, V> getCache(String appId, String servers, String cacheName, int maxConn) {
        ICache cache;
        block3: {
            cache = null;
            try {
                if (StringUtil.isNotEmptyString(servers)) {
                    Class cls = ClassUtil.getClass("com.ygsoft.ecp.service.cache.impl.redis.RedisAdapter");
                    Object[] methodParams = new Object[]{appId, servers, cacheName, maxConn};
                    Object obj = ClassUtil.callMethod(cls, "getCache", methodParams);
                    cache = (ICache)obj;
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error(e.getMessage(), e);
            }
        }
        return cache;
    }
}

