/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.cons.ServerProps;
import com.ygsoft.ecp.service.config.AppServerType;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.cons.SecurityType;
import com.ygsoft.ecp.service.internal.config.ApplicationConfig;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.SecurityUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.SysPropUtil;
import com.ygsoft.ecp.service.tool.ThreadLocalUtil;
import com.ygsoft.ecp.service.tool.VPDUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeEnvUtil {
    private static final String KEY_NECP_MODEL_TRANSFER_POLICY = "model.transfer.policy";
    private static final String KEY_NECP_MODEL_POLICY = "modelPolicy";
    private static final String KEY_NECP_SERVICE_ISREMOTE = "necp.service.isremote";
    private static boolean isCallRemoteService = System.getProperty("necp.service.isremote", "false").equals("true");
    public static final RuntimeEnvUtil INSTANCE = new RuntimeEnvUtil();
    private static final IEcpLog LOG = EcpLogFactory.getLog(RuntimeEnvUtil.class);
    private static final String WEB_SEPARATORCHAR = "/";
    private static final String UAP = "UAP";
    private static final String DAP = "dap";
    private static final String LOCALHOST = "127.0.0.1";
    private static String modelTransferPolicy = null;
    private DataBaseInfo dbInfo = null;
    private AppServerInfo appServerInfo = null;
    private Boolean isVPDSupport;
    private volatile String mainCompID;
    private int uniqueID = 1;
    private volatile boolean isPlus = false;
    private volatile boolean isMini = false;
    private static final int SERVER_STARTED_LEVEL = 105;

    private RuntimeEnvUtil() {
    }

    protected static String getModelTransferPolicyBootKey() {
        return KEY_NECP_MODEL_TRANSFER_POLICY;
    }

    public static String getModelTransferPolicyKey() {
        return KEY_NECP_MODEL_POLICY;
    }

    public static void setThreadModelTransferPolicy(String transferPolicy) {
        block4: {
            if (StringUtil.isEmpty(transferPolicy)) {
                return;
            }
            try {
                Object ret = ThreadLocalUtil.remove(KEY_NECP_MODEL_POLICY);
                ThreadLocalUtil.set(KEY_NECP_MODEL_POLICY, transferPolicy);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("\u8bbe\u7f6e%s=%s", KEY_NECP_MODEL_POLICY, transferPolicy));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error(e.getMessage(), e);
            }
        }
    }

    public static String getModelTransferPolicy() {
        Object modelPolicyObj;
        block3: {
            modelPolicyObj = null;
            try {
                modelPolicyObj = ThreadLocalUtil.get(KEY_NECP_MODEL_POLICY);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error(e.getMessage(), e);
            }
        }
        if (null == modelPolicyObj) {
            return null;
        }
        return modelPolicyObj.toString();
    }

    public static String getSettingModelTransrePolicy() {
        block3: {
            if (StringUtil.isNotEmpty(modelTransferPolicy)) {
                return modelTransferPolicy;
            }
            try {
                modelTransferPolicy = System.getProperty(KEY_NECP_MODEL_TRANSFER_POLICY);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error(e.getMessage(), e);
            }
        }
        return modelTransferPolicy;
    }

    public boolean isMini() {
        return this.isMini;
    }

    public boolean isPlus() {
        return this.isPlus;
    }

    public String getAppId() {
        return ApplicationConfig.INSTANCE.getAppId();
    }

    public String getMainCompID() {
        if (this.mainCompID == null) {
            this.mainCompID = this.getRealCompID("MAIN");
        }
        return this.mainCompID;
    }

    public boolean isOracle() {
        DataBaseInfo dataBaseInfo = this.getDataBaseInfo();
        return dataBaseInfo != null && dataBaseInfo.isOracle;
    }

    public boolean isDeployment() {
        return StringUtil.isNotEmptyString(System.getProperty("ygsoft.gap.plugin"));
    }

    public boolean isUAP() {
        return UAP.equals(System.getProperty("ygsoft.gap.plugin"));
    }

    public boolean isDAP() {
        return DAP.equals(System.getProperty("ygsoft.env").toLowerCase()) || DAP.equals(System.getProperty("ecp.env").toLowerCase());
    }

    private DataSource getDS() {
        return OSGiUtil.getSpringBean(DataSource.class);
    }

    public boolean isH2() {
        DataBaseInfo dataBaseInfo = this.getDataBaseInfo();
        return dataBaseInfo != null && dataBaseInfo.isH2;
    }

    public long getUniqueID() {
        return this.uniqueID++;
    }

    public int getUniqueID(int step) {
        this.uniqueID += step;
        return this.uniqueID;
    }

    public boolean isDevMode() {
        return this.getAppServerInfo().isDevMode;
    }

    public static RuntimeEnvUtil getINSTANCE() {
        return INSTANCE;
    }

    public DataBaseInfo getDbInfo() {
        return this.dbInfo;
    }

    public String getRemoteServiceHost() {
        String url = ServerProps.getProperty((String)"mapp.serviceRegisterUrl");
        if (url != null && url.indexOf(",") > 0) {
            String[] urls = url.split(",");
            double temp = Math.random();
            int length = urls.length;
            int index = (int)(temp * (double)length);
            url = urls[index];
        }
        return url;
    }

    public boolean isEnabledServerRegisterDiscovery() {
        String serverUrl = ServerProps.getProperty((String)"mapp.serviceRegisterUrl");
        return serverUrl != null && serverUrl.trim().length() > 0;
    }

    public int getSelfPort() {
        String port = SysPropUtil.get("server.port");
        if (port == null || port.trim().length() == 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error("\u6ca1\u6709\u914d\u7f6e-Dserver.port=\u5f53\u524d\u5b9e\u4f8b\u7684\u7aef\u53e3\u53f7");
            }
            return 0;
        }
        return Integer.parseInt(port);
    }

    public String getCurRegion() {
        return ServerProps.getProperty((String)"mapp.regionName");
    }

    public String getMappRegion() {
        return ServerProps.getProperty((String)"mapp.region");
    }

    public String getMappName() {
        return ServerProps.getProperty((String)"mapp.name");
    }

    public String getMappVipAddress() {
        return ServerProps.getProperty((String)"mapp.vipAddress");
    }

    public boolean getMappStandAlone() {
        return SysPropUtil.isTrue("mapp.standAlone");
    }

    public String getOsgiCurrentLevel() {
        return ServerProps.getProperty((String)"osgi.current.level");
    }

    public boolean isOsgiServerStarted() {
        String curLevel = this.getOsgiCurrentLevel();
        if (curLevel != null) {
            try {
                int i = Integer.parseInt(curLevel.toString());
                if (i >= 105) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public Boolean getIsVPDSupport() {
        return this.isVPDSupport;
    }

    public String getWebContextPath() {
        return this.getAppServerInfo().webContextPath;
    }

    public String getServerHostIP() {
        return this.getAppServerInfo().serverHostIP;
    }

    public AppServerType getServerType() {
        return this.getAppServerInfo().serverType;
    }

    public String getServerName() {
        return this.getAppServerInfo().serverName;
    }

    public String getServerPath() {
        return this.getAppServerInfo().serverPath;
    }

    public int getServerHostPort() {
        return this.getAppServerInfo().serverHostPort;
    }

    public String getNetProtocol() {
        return this.getAppServerInfo().netProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getRealCompID(String compID) {
        if ("MAIN".equals(compID)) {
            String string;
            ResultSet rs;
            PreparedStatement st;
            Connection conn;
            block33: {
                DatabaseType curDbType;
                if (this.mainCompID != null && !"MAIN".equals(this.mainCompID)) {
                    return this.mainCompID;
                }
                conn = null;
                st = null;
                rs = null;
                conn = this.getDS().getConnection();
                st = conn.prepareStatement("SELECT CSZ FROM XTCS WHERE CSMC = 'COMPID_TOP'");
                rs = st.executeQuery();
                if (rs.next()) {
                    this.mainCompID = rs.getString("CSZ");
                }
                if (DatabaseType.Oracle.equals((Object)(curDbType = ApplicationConfig.INSTANCE.getDatabaseType())) || DatabaseType.DM.equals((Object)curDbType)) {
                    String userName;
                    if ((StringUtil.isEmptyString(this.mainCompID) || "MAIN".equals(this.mainCompID)) && (userName = conn.getMetaData().getUserName()).length() > 4) {
                        this.mainCompID = userName.substring(4);
                    }
                    st = conn.prepareStatement("SELECT SYS_CONTEXT('VPD_CONTEXT','COMPID') AS VPD_CONTEXT FROM DUAL");
                    rs = st.executeQuery();
                    String oldCompid = null;
                    if (rs.next()) {
                        oldCompid = rs.getString("VPD_CONTEXT");
                    }
                    String sql = MessageFormat.format("BEGIN\nvPD_PKG.SET_CONTEXT_COMPID(''{0}'');\nEND;", "-1");
                    st = conn.prepareStatement(sql);
                    st.executeQuery();
                    st = conn.prepareStatement("SELECT SYS_CONTEXT('VPD_CONTEXT','COMPID') AS VPD_CONTEXT FROM DUAL");
                    rs = st.executeQuery();
                    String newCompid = null;
                    if (rs.next()) {
                        newCompid = rs.getString("VPD_CONTEXT");
                    }
                    boolean bl = this.isPlus = !"-1".equals(newCompid);
                    if (this.isPlus) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("\u5f53\u524d\u6570\u636e\u5e93\u73af\u5883\u4e3aPLUS\u73af\u5883");
                        }
                        System.setProperty("isPlus", "true");
                        sql = MessageFormat.format("BEGIN\nvPD_PKG.SET_CONTEXT_COMPID(''{0}'');\nEND;", oldCompid);
                        st = conn.prepareStatement(sql);
                        st.executeQuery();
                        st = conn.prepareStatement("BEGIN\nvPD_PKG.SET_VPD_STATE_ENABLE();\nEND;");
                        st.executeQuery();
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("\u5f53\u524d\u6570\u636e\u5e93\u73af\u5883\u4e3aGRIS\u73af\u5883");
                        }
                        sql = MessageFormat.format("BEGIN\nvPD_PKG.SET_CONTEXT_COMPID(''{0}'');\nEND;", oldCompid);
                        st = conn.prepareStatement(sql);
                        st.executeQuery();
                    }
                    if (SecurityUtil.check(SecurityType.SECURITY_CHECK) && LOG.isInfoEnabled()) {
                        LOG.info("\u5f53\u524d\u73af\u5883\u5f00\u542f\u4e86\u5b89\u5168\u68c0\u67e5");
                    }
                }
                if ((rs = (st = conn.prepareStatement("SELECT CSZ FROM XTCS WHERE CSMC = 'ECP_STANDARD_PRODUCT'")).executeQuery()).next()) {
                    String value = rs.getString("CSZ");
                    boolean bl = this.isMini = value != null && "true".equalsIgnoreCase(value);
                    if (this.isMini && LOG.isInfoEnabled()) {
                        LOG.info("\u5f53\u524d\u6570\u636e\u5e93\u73af\u5883\u4e3a\u3010 ECP MINI\u3011\u6807\u51c6\u5e93\u73af\u5883");
                    }
                }
                this.initVersion(conn, st, rs);
                string = this.mainCompID;
                Object var10_10 = null;
                try {
                    if (null != rs) {
                        rs.close();
                    }
                    if (null != st) {
                        st.close();
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception ex) {
                    if (!LOG.isErrorEnabled()) break block33;
                    LOG.error("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", ex);
                }
            }
            return string;
            catch (Exception e) {
                try {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("\u83b7\u53d6\u5171\u4eab\u5e93\u5355\u4f4d\u7f16\u53f7\u65f6\u53d1\u751f\u5f02\u5e38" + e.getMessage());
                    }
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    block35: {
                        Object var10_12 = null;
                        try {
                            if (null != rs) {
                                rs.close();
                            }
                            if (null != st) {
                                st.close();
                            }
                            if (conn != null && !conn.isClosed()) {
                                conn.close();
                            }
                        }
                        catch (Exception ex) {
                            if (!LOG.isErrorEnabled()) break block35;
                            LOG.error("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", ex);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (null != rs) {
                        rs.close();
                    }
                    if (null != st) {
                        st.close();
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", ex);
                    }
                }
            }
        }
        return compID;
    }

    private void initVersion(Connection conn, PreparedStatement st, ResultSet rs) {
        block7: {
            try {
                st = conn.prepareStatement("SELECT PARAMVALUE FROM ECP_XT_PARAMETER_VALUE WHERE PARAMNAME = 'ECP_START_VERSION'");
                rs = st.executeQuery();
                String version = null;
                if (rs.next()) {
                    version = rs.getString("PARAMVALUE");
                }
                if (StringUtil.isEmptyString(version)) {
                    st = conn.prepareStatement("INSERT INTO ECP_XT_PARAMETER_VALUE (COMPID,PARAMNAME,PARAMVALUE) VALUES(?,'ECP_START_VERSION',?)");
                    st.setString(1, this.mainCompID);
                    st.setString(2, "1");
                    st.execute();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("\u5f53\u524d\u670d\u52a1\u542f\u52a8\u7248\u672c\u53f7\u4e3a\u30101\u3011");
                    }
                } else {
                    st = conn.prepareStatement("UPDATE ECP_XT_PARAMETER_VALUE SET PARAMVALUE = ? WHERE PARAMNAME = 'ECP_START_VERSION'");
                    long v = Long.parseLong(version);
                    st.setString(1, String.valueOf(++v));
                    st.executeUpdate();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("\u5f53\u524d\u670d\u52a1\u542f\u52a8\u7248\u672c\u53f7\u4e3a\u3010" + v + "\u3011");
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error("\u521d\u59cb\u5316\u670d\u52a1\u542f\u52a8\u7248\u672c\u5931\u8d25", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private DataBaseInfo getDataBaseInfo() {
        block12: {
            if (this.dbInfo == null) {
                Connection con = null;
                con = this.getDS().getConnection();
                DatabaseMetaData md = con.getMetaData();
                this.dbInfo = new DataBaseInfo();
                this.dbInfo.product = md.getDatabaseProductName();
                this.dbInfo.isOracle = this.dbInfo.product.indexOf("Oracle") >= 0;
                this.dbInfo.isH2 = this.dbInfo.product.indexOf("H2") >= 0;
                Object var4_4 = null;
                try {
                    if (con != null && !con.isClosed()) {
                        con.close();
                    }
                    break block12;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                break block12;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var4_5 = null;
                        try {
                            if (con != null && !con.isClosed()) {
                                con.close();
                            }
                            break block12;
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    try {
                        if (con != null && !con.isClosed()) {
                            con.close();
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
        return this.dbInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getVersion() {
        String string;
        ResultSet rs;
        PreparedStatement st;
        Connection conn;
        block20: {
            conn = null;
            st = null;
            rs = null;
            conn = this.getDS().getConnection();
            st = conn.prepareStatement("SELECT PARAMVALUE FROM ECP_XT_PARAMETER_VALUE WHERE PARAMNAME = 'ECP_START_VERSION'");
            rs = st.executeQuery();
            String version = null;
            if (rs.next()) {
                version = rs.getString("PARAMVALUE");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5f53\u524d\u670d\u52a1\u542f\u52a8\u7248\u672c\u53f7\u4e3a\u3010" + version + "\u3011");
            }
            string = version;
            Object var7_7 = null;
            try {
                if (null != rs) {
                    rs.close();
                }
                if (null != st) {
                    st.close();
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block20;
                LOG.error("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", ex);
            }
        }
        return string;
        catch (Exception e) {
            try {
                e.printStackTrace();
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                block22: {
                    Object var7_9 = null;
                    try {
                        if (null != rs) {
                            rs.close();
                        }
                        if (null != st) {
                            st.close();
                        }
                        if (conn != null && !conn.isClosed()) {
                            conn.close();
                        }
                    }
                    catch (Exception ex) {
                        if (!LOG.isErrorEnabled()) break block22;
                        LOG.error("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", ex);
                    }
                }
                throw throwable;
            }
            try {
                if (null != rs) {
                    rs.close();
                }
                if (null != st) {
                    st.close();
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u53d1\u751f\u5f02\u5e38", ex);
                }
            }
        }
        return null;
    }

    private AppServerInfo getAppServerInfo() {
        if (this.appServerInfo == null) {
            this.appServerInfo = new AppServerInfo();
            this.initServerType(this.appServerInfo);
            this.appServerInfo.isDevMode = System.getProperty("ygsoft.gap.plugin") == null;
            this.appServerInfo.webContextPath = System.getProperty("ecp_context");
            if (StringUtil.isEmptyString(this.appServerInfo.webContextPath)) {
                this.appServerInfo.webContextPath = "/grm";
            }
            this.appServerInfo.serverHostIP = System.getProperty("ecp_ip");
            if (StringUtil.isEmptyString(this.appServerInfo.serverHostIP)) {
                this.appServerInfo.serverHostIP = this.getHostAddress();
            }
            this.appServerInfo.serverHostPort = StringUtil.isEmptyString(System.getProperty("ecp_port")) ? 9080 : Integer.parseInt(System.getProperty("ecp_port"));
            this.appServerInfo.netProtocol = System.getProperty("ecp_protocol");
            if (StringUtil.isEmptyString(this.appServerInfo.netProtocol)) {
                this.appServerInfo.netProtocol = "http";
            } else {
                int pos = this.appServerInfo.netProtocol.indexOf(WEB_SEPARATORCHAR);
                if (pos > -1) {
                    this.appServerInfo.netProtocol = this.appServerInfo.netProtocol.substring(0, pos);
                }
            }
        }
        return this.appServerInfo;
    }

    void initServerType(AppServerInfo appServerInfo) {
        String serverInfo = SysPropUtil.get("serverinfo");
        if (StringUtil.isEmptyString(serverInfo)) {
            appServerInfo.serverType = AppServerType.Jetty;
            return;
        }
        if (serverInfo.startsWith("IBM WebSphere Application")) {
            appServerInfo.serverType = AppServerType.Websphere;
        } else if (serverInfo.startsWith("SAP")) {
            appServerInfo.serverType = AppServerType.Netweaver;
        } else if (serverInfo.startsWith("Apusic")) {
            appServerInfo.serverType = AppServerType.Apusic;
        } else if (serverInfo.startsWith("InforSuite")) {
            String serverName = System.getProperty("com.cvicse.las.instanceRoot");
            if (serverName != null && serverName.length() > 1) {
                serverName = serverName.substring(serverName.lastIndexOf(WEB_SEPARATORCHAR) + 1);
            }
            appServerInfo.serverType = AppServerType.Inforsuite;
            appServerInfo.serverName = serverName;
        } else if (serverInfo.startsWith("SMF Web")) {
            appServerInfo.serverType = AppServerType.YGcloud;
            appServerInfo.serverName = System.getProperty("wlp.server.name");
        } else if (serverInfo.startsWith("Vsettan ToprowAS")) {
            appServerInfo.serverType = AppServerType.YGcloud;
            appServerInfo.serverName = System.getProperty("wlp.server.name");
        } else if (serverInfo.startsWith("Apache Tomcat")) {
            String jbossServerName = System.getProperty("jboss.server.name");
            if (jbossServerName != null) {
                appServerInfo.serverType = AppServerType.Jboss;
                appServerInfo.serverName = jbossServerName;
            } else {
                appServerInfo.serverType = AppServerType.Tomcat;
                appServerInfo.serverName = serverInfo;
            }
        } else if (serverInfo.startsWith("jetty")) {
            appServerInfo.serverType = AppServerType.Jetty;
            appServerInfo.serverName = serverInfo;
        } else {
            appServerInfo.serverType = AppServerType.Weblogic;
            appServerInfo.serverName = System.getProperty("weblogic.Name");
        }
        try {
            this.setServerPath(appServerInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setServerPath(AppServerInfo appServerInfo) {
        String path = System.getProperty("user.dir");
        if (path != null) {
            String str = WEB_SEPARATORCHAR + appServerInfo.serverName + WEB_SEPARATORCHAR;
            int index = path.indexOf(str) + str.length();
            if (AppServerType.Weblogic.equals((Object)appServerInfo.serverType) || AppServerType.YGcloud.equals((Object)appServerInfo.serverType) || AppServerType.Websphere.equals((Object)appServerInfo.serverType)) {
                str = "/servers/" + appServerInfo.serverName + WEB_SEPARATORCHAR;
                index = path.indexOf(str) + str.length();
            } else if (AppServerType.Inforsuite.equals((Object)appServerInfo.serverType)) {
                str = "/domains/" + appServerInfo.serverName + WEB_SEPARATORCHAR;
                index = path.indexOf(str) + str.length();
            }
            if (index > 0) {
                appServerInfo.serverPath = path.substring(0, index);
            }
        }
    }

    private String getHostAddress() {
        List<String> ipList = this.getLocalIPList();
        if (ipList.isEmpty()) {
            return LOCALHOST;
        }
        if (ipList.size() > 1 && LOG.isInfoEnabled()) {
            LOG.info("\u670d\u52a1\u5668\u6709\u591a\u4e2aIP\u5730\u5740[ " + StringUtil.ListToString(ipList) + "]\u4f7f\u7528\u83b7\u53d6\u5230\u7684\u7b2c\u4e00\u4e2aIP\u5730\u5740\u8fd4\u56de");
        }
        return ipList.get(0);
    }

    public List<String> getLocalIPList() {
        ArrayList<String> ipList;
        block4: {
            ipList = new ArrayList<String>();
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        String ip;
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (inetAddress == null || !(inetAddress instanceof Inet4Address) || LOCALHOST.equals(ip = inetAddress.getHostAddress())) continue;
                        ipList.add(ip);
                    }
                }
            }
            catch (SocketException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("\u83b7\u53d6\u670d\u52a1\u5668IP\u5730\u5740\u53d1\u751f\u5f02\u5e38", e);
            }
        }
        return ipList;
    }

    public boolean isVPDSupport() {
        if (this.isVPDSupport == null) {
            try {
                String compID = VPDUtil.getVPDCompID();
                this.isVPDSupport = !StringUtil.isEmptyString(compID);
            }
            catch (Exception e) {
                this.isVPDSupport = false;
            }
        }
        return this.isVPDSupport;
    }

    public static boolean isCallRemoteService() {
        return isCallRemoteService;
    }

    public static class AppServerInfo {
        boolean isDevMode;
        String serverPath;
        AppServerType serverType;
        String serverName;
        String webContextPath;
        String serverHostIP;
        int serverHostPort;
        String netProtocol;
    }

    public static class DataBaseInfo {
        String product;
        boolean isOracle;
        boolean isH2;
    }
}

