/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.cons.SecurityType;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.SysPropUtil;
import com.ygsoft.ecp.service.tool.XtcsUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityUtil
implements IEcpToolLogic {
    private static final String SQL_PARSER_CLASS = "org.hibernate.util.SqlParser";
    public static final SecurityType[] SECURITY_ITEMS = new SecurityType[]{SecurityType.SECURITY_CHECK, SecurityType.CODE_CHECK, SecurityType.CSRF_CHECK, SecurityType.HELP_CHECK, SecurityType.WEB_CHECK, SecurityType.VERIFIER_CHECK, SecurityType.KH_CHECK, SecurityType.DYH_CHECK, SecurityType.WS_CHECK};

    private SecurityUtil() {
    }

    public static boolean check(SecurityType type) {
        return SecurityUtil.check(type.name());
    }

    public static boolean check(String type) {
        if (SecurityType.SECURITY_CHECK.name().equals(type)) {
            return SecurityUtil.isSecurityEnable();
        }
        return SecurityUtil.isSecurityEnable() && SecurityUtil.isTrue(type);
    }

    private static boolean isSecurityEnable() {
        return SecurityUtil.isTrue(SecurityType.SECURITY_CHECK.name());
    }

    private static boolean isTrue(String key) {
        return Boolean.valueOf(SysPropUtil.get(key));
    }

    public static Map<String, Boolean> getSecuritySettings() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (SecurityType type : SECURITY_ITEMS) {
            map.put(type.name(), SecurityUtil.check(type.name()));
        }
        return map;
    }

    public static String guessColumn(String sql) {
        DatabaseType dbtype = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        return SecurityUtil.guessColumn(sql, SecurityUtil.getDBName(dbtype));
    }

    private static String getDBName(DatabaseType dbtype) {
        String dbname = null;
        dbname = dbtype == null ? DatabaseType.Oracle.name() : dbtype.name();
        return dbname;
    }

    public static String guessColumns(String sql, String dbtype) {
        try {
            Class cls = ClassUtil.getClass(SQL_PARSER_CLASS);
            return ClassUtil.callMethod(cls, "guessColumns", new Object[]{sql, dbtype}).toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String guessColumn(String sql, String dbtype) {
        try {
            Class cls = ClassUtil.getClass(SQL_PARSER_CLASS);
            return ClassUtil.callMethod(cls, "guessColumn", new Object[]{sql, dbtype}).toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String[] guessTable(String sql) {
        DatabaseType dbtype = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        return SecurityUtil.guessTable(sql, SecurityUtil.getDBName(dbtype));
    }

    public static String[] guessTable(String sql, String dbtype) {
        try {
            Class cls = ClassUtil.getClass(SQL_PARSER_CLASS);
            return (String[])ClassUtil.callMethod(cls, "guessTable", new Object[]{sql, dbtype});
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<String> checkSQL(String sql) {
        DatabaseType dbtype = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        return SecurityUtil.checkSQL(sql, SecurityUtil.getDBName(dbtype));
    }

    public static List<String> checkSQL(String sql, String dbtype) {
        try {
            Class cls = ClassUtil.getClass(SQL_PARSER_CLASS);
            return (List)ClassUtil.callMethod(cls, "check", new Object[]{sql, dbtype});
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public static boolean isValidate(String sql) {
        DatabaseType dbtype = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        return SecurityUtil.isValidate(sql, SecurityUtil.getDBName(dbtype));
    }

    public static boolean isValidate(String sql, String dbtype) {
        return SecurityUtil.checkSQL(sql, dbtype).isEmpty();
    }

    static {
        if (RuntimeEnvUtil.INSTANCE.isPlus() && !XtcsUtil.isMultiLevelDeployMode()) {
            for (SecurityType checkItem : SECURITY_ITEMS) {
                if (SysPropUtil.get(checkItem.name()) != null) continue;
                if (checkItem == SecurityType.KH_CHECK || checkItem == SecurityType.CSRF_CHECK) {
                    SysPropUtil.set(checkItem.name(), "false");
                    continue;
                }
                SysPropUtil.set(checkItem.name(), "true");
            }
        }
    }
}

