/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.framework.actuator.IMonitor;
import com.ygsoft.ecp.framework.actuator.TraceHolder;
import com.ygsoft.ecp.framework.actuator.TraceModel;
import com.ygsoft.ecp.framework.cons.MappConst;
import com.ygsoft.ecp.framework.cons.ServerProps;
import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import com.ygsoft.ecp.framework.token.TokenHolder;
import com.ygsoft.ecp.framework.util.IPUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;

public final class TraceLogUtil {
    public static final String ERROR_HEADERPREFIX = "ERROR_CODE";
    private static final String CALL_START_TIME = "CALL_START_TIME";
    private static final String PRE_HANDLE_START_TIME = "PRE_HANDLE_START_TIME";
    public static final String NAME = "name";
    public static final String CALL_NAME = "callName";
    private static final String[] URL_SERVER_ROUTE = new String[]{"/ecp/webcore/remoteService", "/ecp/RemoteServiceServlet", "/ecp/EfNavigateServlet", "/ecp/component.ef/MetaModelManagerServlet", "/ecp/component.ef/PageConfigServlet", "/ecp/ext.exp.func/EcpQSManagerServlet", "/core.workflow.engine/workflow/start.html", "/core.workflow.engine/workflow/todo.html", "/ecm/contentmanage", "/gris/contentmanage", "/ecp/CommonExportServlet", "/ecp/DefaultExportServlet", "/ecp/FileAccessServlet", "/ecp/webcore/FileAccessServlet", "/teamef/PosExportServlet", "/business/framework/CommonExportServlet", "/pdf/PdfServlet", "/component.query/run/scheme/"};

    private TraceLogUtil() {
    }

    public static boolean isTraceLogEnabled() {
        ApplicationContext ac = SpringContextHolder.INSTANCE.getApplicationContext();
        if (ac == null) {
            return false;
        }
        return ac.containsBean("CommonMonitor");
    }

    public static void initTraceInfo(HttpServletRequest httpRequest) {
        if (TraceLogUtil.isTraceLogEnabled()) {
            TokenHolder.INSTANCE.setRequest(httpRequest);
            httpRequest.setAttribute(PRE_HANDLE_START_TIME, (Object)System.nanoTime());
            httpRequest.setAttribute(CALL_START_TIME, (Object)System.currentTimeMillis());
        }
    }

    public static void clearTraceInfo(HttpServletRequest httpRequest) {
        if (TraceLogUtil.isTraceLogEnabled()) {
            TokenHolder.INSTANCE.clearToken();
            TraceHolder.INSTANCE.clearPid();
            TraceHolder.INSTANCE.clearId();
            TraceHolder.INSTANCE.clearLog();
            TokenHolder.INSTANCE.clearClientIP();
            httpRequest.removeAttribute(PRE_HANDLE_START_TIME);
            httpRequest.removeAttribute(CALL_START_TIME);
        }
    }

    public static void clearTraceInfo() {
        if (TraceLogUtil.isTraceLogEnabled()) {
            TokenHolder.INSTANCE.clearToken();
            TraceHolder.INSTANCE.clearPid();
            TraceHolder.INSTANCE.clearId();
            TraceHolder.INSTANCE.clearLog();
            TokenHolder.INSTANCE.clearClientIP();
        }
    }

    public static void processLog(HttpURLConnection urlConnection, String errorMsg, String className, String methodName, String token, long beginTime, long callStartTime, String restUrl) {
        String registerUrl;
        String ip;
        if (!TraceLogUtil.isTraceLogEnabled()) {
            return;
        }
        if (!TraceLogUtil.isLogTrace()) {
            return;
        }
        long time = System.nanoTime() - beginTime;
        TraceModel model = new TraceModel();
        model.setRestApi(restUrl);
        model.setTimeConsuming(time);
        model.setCreateTimeNs(beginTime);
        model.setCreateTime(callStartTime);
        boolean errorFlag = false;
        if (errorMsg != null) {
            model.setError(errorMsg);
            errorFlag = true;
        } else {
            String errorCode = TraceHolder.INSTANCE.getErrorCode();
            if (errorCode != null) {
                model.setError(errorCode);
                errorFlag = true;
            }
        }
        model.setId(TraceHolder.INSTANCE.getId());
        model.setPid(TraceHolder.INSTANCE.getPid());
        model.setTid(TraceHolder.INSTANCE.getTid());
        model.setToken(token);
        String vip = System.getProperty("server.vipaddress");
        if (vip == null) {
            vip = "null";
        }
        if ((ip = IPUtil.getHostIP()) == null) {
            ip = "null";
        }
        if ((registerUrl = ServerProps.getProperty((String)"mapp.serviceRegisterUrl")) == null) {
            registerUrl = "null";
        }
        model.setClassName(className);
        model.setMethodName(methodName);
        try {
            model.setSourceVip(URLEncoder.encode(vip, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        model.setSourceIp(ip);
        model.setSourcePort(MappConst.getServerPort());
        try {
            model.setTargetVip(URLEncoder.encode(vip, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        model.setTargetIp(ip);
        model.setTargetPort(MappConst.getServerPort());
        model.setRegisterUrl(registerUrl);
        String clientIP = TokenHolder.INSTANCE.getClientIP();
        if (clientIP == null) {
            clientIP = IPUtil.getHostIP();
        }
        TraceLogUtil.processLog(model);
        if (errorFlag) {
            TraceLogUtil.clearTraceInfo();
        }
    }

    private static void processLog(TraceModel model) {
        ApplicationContext ac = SpringContextHolder.INSTANCE.getApplicationContext();
        if (ac.containsBean("CommonMonitor")) {
            ((IMonitor)ac.getBean(IMonitor.class)).process(model);
            TraceHolder.INSTANCE.setLoged();
        }
    }

    public static void processErrorcode(HttpURLConnection urlConnection) {
        if (TraceLogUtil.isTraceLogEnabled()) {
            int size = urlConnection.getHeaderFields().size();
            for (int i = 0; i < size; ++i) {
                String name = urlConnection.getHeaderFieldKey(i);
                String value = urlConnection.getHeaderField(i);
                if (!StringUtil.isNotEmpty(name) || !ERROR_HEADERPREFIX.equals(name)) continue;
                TraceHolder.INSTANCE.setErrorCode(value);
                break;
            }
        }
    }

    public static void setTraceHeader(HttpURLConnection urlConnection) {
        if (!TraceLogUtil.isTraceLogEnabled()) {
            return;
        }
        try {
            String registerUrl;
            String ip;
            String vip;
            String username;
            String pid;
            String tid = TraceHolder.INSTANCE.getTid();
            if (tid == null) {
                tid = "null";
            }
            if ((pid = TraceHolder.INSTANCE.getId()) == null) {
                pid = "null";
            }
            if ((username = TraceHolder.INSTANCE.getUsername()) == null) {
                username = "null";
            }
            if ((vip = System.getProperty("server.vipaddress")) == null) {
                vip = "null";
            }
            if ((ip = IPUtil.getHostIP()) == null) {
                ip = "null";
            }
            if ((registerUrl = ServerProps.getProperty((String)"mapp.serviceRegisterUrl")) == null) {
                registerUrl = "null";
            }
            urlConnection.setRequestProperty("trice_tid", tid);
            urlConnection.setRequestProperty("trice_pid", pid);
            urlConnection.setRequestProperty("trice_userName", username);
            urlConnection.setRequestProperty("trice_sourceVip", URLEncoder.encode(vip, "UTF-8"));
            urlConnection.setRequestProperty("trice_sourceIp", ip);
            urlConnection.setRequestProperty("trice_soucePort", MappConst.getServerPort() + "");
            urlConnection.setRequestProperty("trice_registerUrl", URLEncoder.encode(registerUrl, "UTF-8"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static boolean isRest(String pathURI) {
        for (String url : URL_SERVER_ROUTE) {
            if (!pathURI.startsWith(url)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLogTrace() {
        String traceLog = TraceHolder.INSTANCE.getLoged();
        return StringUtil.isEmpty(traceLog);
    }
}

