/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class TransactionUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(TransactionUtil.class);
    private static AbstractPlatformTransactionManager transactionManager = null;

    private TransactionUtil() {
    }

    public static void setTransactionManager(AbstractPlatformTransactionManager newtransactionManager) {
        transactionManager = newtransactionManager;
    }

    public static Object doInTransactionWithoutRollback(ITXWithoutRollback callback) {
        TransactionUtil.checkInTransaction();
        Object result = null;
        if (transactionManager == null) {
            transactionManager = (AbstractPlatformTransactionManager)OSGiUtil.getService(PlatformTransactionManager.class);
        }
        transactionManager.setGlobalRollbackOnParticipationFailure(false);
        try {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u4e8b\u52a1\u95ed\u5305\u8c03\u7528\u5f00\u59cb\uff0c\u8bbe\u7f6e\u4e8b\u52a1\u53d1\u751f\u5f02\u5e38\u5168\u5c40\u56de\u6eda\u6807\u5fd7\u4e3a\u5047");
                }
                result = callback.execute();
            }
            catch (Throwable ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u4e8b\u52a1\u95ed\u5305\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff0c" + ex.getMessage());
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            Object var4_2 = null;
            if (LOG.isInfoEnabled()) {
                LOG.info("\u4e8b\u52a1\u95ed\u5305\u8c03\u7528\u5b8c\u6bd5\uff0c\u8bbe\u7f6e\u4e8b\u52a1\u53d1\u751f\u5f02\u5e38\u5168\u5c40\u56de\u6eda\u6807\u5fd7\u4e3a\u771f");
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (LOG.isInfoEnabled()) {
                LOG.info("\u4e8b\u52a1\u95ed\u5305\u8c03\u7528\u5b8c\u6bd5\uff0c\u8bbe\u7f6e\u4e8b\u52a1\u53d1\u751f\u5f02\u5e38\u5168\u5c40\u56de\u6eda\u6807\u5fd7\u4e3a\u771f");
            }
            transactionManager.setGlobalRollbackOnParticipationFailure(true);
            throw throwable;
        }
        transactionManager.setGlobalRollbackOnParticipationFailure(true);
        return result;
    }

    private static void checkInTransaction() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new UnsupportedOperationException("\u8be5\u65b9\u6cd5\u5fc5\u987b\u5728\u4e8b\u52a1\u73af\u5883\u4f7f\u7528");
        }
    }

    public static interface ITXWithoutRollback {
        public Object execute();
    }
}

