/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.datasource.DatasourceManager;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;

public final class XtcsUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(XtcsUtil.class);
    private static DataSource dataSource;

    private static void setDataSourceInternal(DataSource newdataSource) {
        dataSource = newdataSource;
    }

    public void setDataSource(DataSource newdataSource) {
        XtcsUtil.setDataSourceInternal(newdataSource);
    }

    private XtcsUtil() {
    }

    public static DataSource getDataSource() {
        if (dataSource == null) {
            dataSource = DatasourceManager.INSTANCE.getDefaultDataSource();
        }
        return dataSource;
    }

    public static String readConfigValueThreePhase(String groupName, String propKey, String csmc, String userConfigValuePath) {
        String regex = "\\.";
        return XtcsUtil.readConfigValueThreePhase(groupName, propKey, csmc, userConfigValuePath, "\\.");
    }

    public static String readConfigValueThreePhase(String groupName, String propKey, String csmc, String userConfigValuePath, String regex) {
        if (null != userConfigValuePath && userConfigValuePath.length() > 0) {
            String[] params = userConfigValuePath.split(regex);
            int paramLength = 3;
            if (params.length == 3) {
                return XtcsUtil.readConfigValueThreePhase(groupName, propKey, csmc, params[0], params[1], params[2]);
            }
            return "";
        }
        return XtcsUtil.readConfigValueThreePhase(groupName, propKey, csmc, null, null, null);
    }

    public static String readConfigValueThreePhase(String groupName, String propKey, String csmc, String userConfigModule, String userConfigGroup, String userConfigValueKey) {
        String configValue = "";
        String valueFromEcpConfig = XtcsUtil.getConfigValueFromEcpConfig(groupName, propKey);
        if (null != valueFromEcpConfig && valueFromEcpConfig.length() > 0) {
            return valueFromEcpConfig;
        }
        String valueFromXtcs = XtcsUtil.getConfigValueFromXtcs(csmc);
        if (null != valueFromXtcs && valueFromXtcs.length() > 0) {
            return valueFromXtcs;
        }
        String valueFromUserConfig = XtcsUtil.getConfigValueFromUserConfig(userConfigModule, userConfigGroup, userConfigValueKey);
        if (null != valueFromUserConfig && valueFromUserConfig.length() > 0) {
            return valueFromUserConfig;
        }
        return "";
    }

    public static String getConfigValueFromEcpConfig(String groupName, String propKey) {
        String value = "";
        if (null == groupName || groupName.length() == 0) {
            return value;
        }
        try {
            value = "";
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u4eceEcpConfig\u4e2d\u8bfb\u53d6\u5230%1$s/%2$s\u7684\u503c\u4e3a:%3$s", groupName, propKey, value));
            }
            return value;
        }
        catch (Exception e) {
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigValueFromXtcs(String csmc) {
        String value = "";
        if (null == csmc || csmc.length() == 0) {
            return value;
        }
        if (XtcsUtil.getDataSource() == null) {
            return value;
        }
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            String schema = "";
            conn = dataSource.getConnection();
            String dbName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            if (!DatabaseType.H2.name().toLowerCase().endsWith(dbName)) {
                schema = dbName.indexOf(DatabaseType.MySql.name().toLowerCase()) > -1 || dbName.indexOf(DatabaseType.GBase.name().toLowerCase()) > -1 ? conn.getCatalog() + "." : conn.getMetaData().getUserName() + ".";
            }
            st = conn.prepareStatement("SELECT CSZ FROM " + schema + "XTCS WHERE CSMC = ?");
            st.setString(1, csmc);
            rs = st.executeQuery();
            if (rs.next()) {
                value = rs.getString(1);
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("\u4ece\u7cfb\u7edf\u53c2\u6570\u8868\u4e2d\u8bfb\u53d6\u5230%1$s\u7684\u503c\u4e3a\uff1a%2$s", csmc, value));
                }
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("\u4ece\u6570\u636e\u5e93xtcs\u83b7\u53d6\u7f13\u5b58\u914d\u7f6e\u4fe1\u606f\u5931\u8d25 " + e.getMessage());
            }
        }
        finally {
            block21: {
                try {
                    if (null != rs) {
                        rs.close();
                    }
                    if (null != st) {
                        st.close();
                    }
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception e2) {
                    if (!LOG.isErrorEnabled()) break block21;
                    LOG.error("\u6570\u636e\u5e93\u8fde\u63a5\u5173\u95ed\u5f02\u5e38 ");
                }
            }
        }
        return value;
    }

    public static String getConfigValueFromUserConfig(String userConfigModule, String userConfigGroup, String userConfigValueKey) {
        if (null == userConfigModule || userConfigModule.length() == 0) {
            return "";
        }
        if (null == userConfigModule || userConfigModule.length() == 0) {
            return "";
        }
        if (null == userConfigValueKey || userConfigValueKey.length() == 0) {
            return "";
        }
        String value = "";
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u4eceUserConfig\u4e2d\u8bfb\u53d6\u5230%1$s/%2$s/%3$s\u7684\u503c\u4e3a:%4$s", userConfigModule, userConfigGroup, userConfigValueKey, ""));
        }
        return "";
    }

    public static boolean isMultiLevelDeployMode() {
        return "true".equals(System.getProperty("xncs"));
    }

    public static boolean isMonitorInputOutput() {
        return "true".equals(EcpService.getCacheService("xtcs").get("MONITOR_IO_ACCESS"));
    }

    public static boolean isMonitorLogAccess() {
        return "true".equals(EcpService.getCacheService("xtcs").get("MONITOR_LOG_ACCESS"));
    }

    public static boolean isCacheRemoveAllAccess() {
        return "true".equals(EcpService.getCacheService("xtcs").get("CACHE_REMOVEALL_ACCESS"));
    }

    public static int getMointorDay() {
        Object day = EcpService.getCacheService("xtcs").get("MONITOR_STORE_DAY");
        if (day != null) {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u83b7\u53d6\u76d1\u63a7\u4fe1\u606f\u5b58\u653e\u65f6\u957f\u4e3a\uff1a" + day + "\u5929");
                }
                return Integer.parseInt(day.toString());
            }
            catch (NumberFormatException ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("\u4f20\u5165\u7684\u65f6\u95f4\u4e0d\u5408\u6cd5,\u4e0d\u662f\u6570\u503c\u7c7b\u578b" + day);
                }
                return 0;
            }
        }
        return 0;
    }
}

