/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipUtil {
    private static final int BUFFSIZE = 0x400000;
    private static final String SUFFIX = ".zip";
    private static final int BUFFER = 512;

    private ZipUtil() {
    }

    public static <T> void writeObjectToZip(T obj, String fileName, String zipPath) throws IOException {
        String temFilePath = zipPath + ".tmp";
        String storagePath = zipPath;
        File tempFile = new File(temFilePath);
        temFilePath = tempFile.getAbsolutePath();
        if (tempFile.exists()) {
            tempFile.delete();
        }
        File licStoragefile = new File(zipPath);
        ZipUtil.createDir(licStoragefile);
        storagePath = licStoragefile.getAbsolutePath();
        FileOutputStream fileOutS = null;
        ZipOutputStream zipOutS = null;
        ByteArrayInputStream bis = null;
        BufferedInputStream bfis = null;
        try {
            byte[] objBytes = ZipUtil.serializeObject(obj);
            if (licStoragefile.exists() && licStoragefile.length() > 0L) {
                licStoragefile.renameTo(tempFile);
                fileOutS = new FileOutputStream(storagePath);
                zipOutS = new ZipOutputStream(new BufferedOutputStream(fileOutS));
                ZipFile zf = new ZipFile(temFilePath);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ZipUtil.zipExistFile(fileName, zipOutS, zf, entries);
                }
                zf.close();
            } else {
                fileOutS = new FileOutputStream(storagePath);
                zipOutS = new ZipOutputStream(new BufferedOutputStream(fileOutS));
            }
            bis = new ByteArrayInputStream(objBytes);
            bfis = new BufferedInputStream(bis);
            ZipEntry entry = new ZipEntry(fileName);
            zipOutS.putNextEntry(entry);
            ZipUtil.copy(bfis, zipOutS);
            zipOutS.closeEntry();
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            ZipUtil.finishWriteObj(temFilePath, fileOutS, zipOutS, bis, bfis);
            throw throwable;
        }
        ZipUtil.finishWriteObj(temFilePath, fileOutS, zipOutS, bis, bfis);
    }

    public static void compress(String dirPath, String zipFileName) {
        File dirFile = new File(dirPath);
        List<File> fileList = ZipUtil.getAllFile(dirFile);
        byte[] buffer = new byte[512];
        ZipEntry zipEntry = null;
        int readLength = 0;
        try {
            CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(zipFileName), new CRC32());
            ZipOutputStream zos = new ZipOutputStream(cos);
            for (File file : fileList) {
                if (file.isFile()) {
                    zipEntry = new ZipEntry(ZipUtil.getRelativePath(dirPath, file));
                    zipEntry.setSize(file.length());
                    zipEntry.setTime(file.lastModified());
                    zos.putNextEntry(zipEntry);
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                    while ((readLength = ((InputStream)is).read(buffer, 0, 512)) != -1) {
                        zos.write(buffer, 0, readLength);
                    }
                    ((InputStream)is).close();
                    System.out.println("file compress:" + file.getCanonicalPath());
                    continue;
                }
                zipEntry = new ZipEntry(ZipUtil.getRelativePath(dirPath, file));
                zos.putNextEntry(zipEntry);
                System.out.println("dir compress: " + file.getCanonicalPath() + "/");
            }
            zos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void decompress(String zipFileName, String destPath) {
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFileName));
            ZipEntry zipEntry = null;
            byte[] buffer = new byte[512];
            int readLength = 0;
            while ((zipEntry = zis.getNextEntry()) != null) {
                File file;
                if (zipEntry.isDirectory() && !(file = new File(destPath + "/" + zipEntry.getName())).exists()) {
                    file.mkdirs();
                    System.out.println("mkdirs:" + file.getCanonicalPath());
                    continue;
                }
                file = ZipUtil.createFile(destPath, zipEntry.getName());
                System.out.println("file created: " + file.getCanonicalPath());
                FileOutputStream os = new FileOutputStream(file);
                while ((readLength = zis.read(buffer, 0, 512)) != -1) {
                    ((OutputStream)os).write(buffer, 0, readLength);
                }
                ((OutputStream)os).close();
                System.out.println("file uncompressed: " + file.getCanonicalPath());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<File> getAllFile(File dirFile) {
        File[] files;
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files = dirFile.listFiles()) {
            if (file.isFile()) {
                fileList.add(file);
                System.out.println("add file:" + file.getName());
                continue;
            }
            if (file.listFiles().length != 0) {
                fileList.addAll(ZipUtil.getAllFile(file));
                continue;
            }
            fileList.add(file);
            System.out.println("add empty dir:" + file.getName());
        }
        return fileList;
    }

    public static String getRelativePath(String dirPath, File file) {
        File dirFile = new File(dirPath);
        String relativePath = file.getName();
        while ((file = file.getParentFile()) != null && !file.equals(dirFile)) {
            relativePath = file.getName() + "/" + relativePath;
        }
        return relativePath;
    }

    public static File createFile(String destPath, String fileName) {
        String[] dirs = fileName.split("/");
        File file = new File(destPath);
        if (dirs.length > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                file = new File(file, dirs[i]);
            }
            if (!file.exists()) {
                file.mkdirs();
                try {
                    System.out.println("mkdirs: " + file.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            file = new File(file, dirs[dirs.length - 1]);
            return file;
        }
        if (!file.exists()) {
            file.mkdirs();
            try {
                System.out.println("mkdirs: " + file.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        file = new File(file, dirs[0]);
        return file;
    }

    public static void zipFile(String fileName, String zipPath) throws IOException {
        String temFilePath = zipPath + ".tmp";
        String storagePath = zipPath;
        File tempFile = new File(temFilePath);
        temFilePath = tempFile.getAbsolutePath();
        if (tempFile.exists()) {
            tempFile.delete();
        }
        File licStoragefile = new File(zipPath);
        ZipUtil.createDir(licStoragefile);
        storagePath = licStoragefile.getAbsolutePath();
        FileOutputStream fileOutS = null;
        ZipOutputStream zipOutS = null;
        ByteArrayInputStream bis = null;
        BufferedInputStream bfis = null;
        try {
            byte[] objBytes = ZipUtil.serializeObject("mytest");
            if (licStoragefile.exists() && licStoragefile.length() > 0L) {
                licStoragefile.renameTo(tempFile);
                fileOutS = new FileOutputStream(storagePath);
                zipOutS = new ZipOutputStream(new BufferedOutputStream(fileOutS));
                ZipFile zf = new ZipFile(temFilePath);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ZipUtil.zipExistFile(fileName, zipOutS, zf, entries);
                }
                zf.close();
            } else {
                fileOutS = new FileOutputStream(storagePath);
                zipOutS = new ZipOutputStream(new BufferedOutputStream(fileOutS));
            }
            bis = new ByteArrayInputStream(objBytes);
            bfis = new BufferedInputStream(bis);
            ZipEntry entry = new ZipEntry(fileName);
            zipOutS.putNextEntry(entry);
            ZipUtil.copy(bfis, zipOutS);
            zipOutS.closeEntry();
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            ZipUtil.finishWriteObj(temFilePath, fileOutS, zipOutS, bis, bfis);
            throw throwable;
        }
        ZipUtil.finishWriteObj(temFilePath, fileOutS, zipOutS, bis, bfis);
    }

    private static void zipExistFile(String fileName, ZipOutputStream zipOutS, ZipFile zf, Enumeration<? extends ZipEntry> entries) throws IOException {
        ZipEntry e = entries.nextElement();
        if (!fileName.equalsIgnoreCase(e.getName())) {
            zipOutS.putNextEntry(e);
            if (!e.isDirectory()) {
                InputStream eis = zf.getInputStream(e);
                ZipUtil.copy(eis, zipOutS);
                eis.close();
            }
            zipOutS.closeEntry();
        }
    }

    private static void finishWriteObj(String temFilePath, FileOutputStream fileOutS, ZipOutputStream zipOutS, ByteArrayInputStream bis, BufferedInputStream bfis) throws IOException {
        File delFile;
        if (bfis != null) {
            bfis.close();
        }
        if (bis != null) {
            bis.close();
        }
        if (zipOutS != null) {
            zipOutS.close();
        }
        if (fileOutS != null) {
            fileOutS.close();
        }
        if ((delFile = new File(temFilePath)).exists()) {
            delFile.delete();
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T getObjectFromZip(String fileName, String zipPath) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzipFile(String zipPath, String fileName) throws IOException, ClassNotFoundException {
        ZipInputStream zin;
        BufferedInputStream in;
        block13: {
            ZipEntry ze;
            File licStoragefile = new File(zipPath);
            if (!licStoragefile.exists()) {
                return;
            }
            byte[] b = null;
            in = null;
            zin = null;
            in = new BufferedInputStream(new FileInputStream(licStoragefile.getAbsolutePath()));
            zin = new ZipInputStream(in);
            while ((ze = zin.getNextEntry()) != null) {
                String entryName = ze.getName();
                if (!entryName.equalsIgnoreCase(fileName)) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipUtil.copy(zin, baos);
                b = baos.toByteArray();
                baos.flush();
                baos.close();
                break;
            }
            if (b != null) break block13;
            Object var10_10 = null;
            if (zin != null) {
                zin.closeEntry();
                zin.close();
            }
            if (in == null) return;
            ((InputStream)in).close();
            return;
        }
        Object var10_11 = null;
        if (zin != null) {
            zin.closeEntry();
            zin.close();
        }
        if (in == null) return;
        ((InputStream)in).close();
        return;
        {
            catch (IOException e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (zin != null) {
                zin.closeEntry();
                zin.close();
            }
            if (in == null) throw throwable;
            ((InputStream)in).close();
            throw throwable;
        }
    }

    public static byte[] serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream byteout = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(byteout);
        outputStream.writeObject(obj);
        outputStream.close();
        byte[] bdata = byteout.toByteArray();
        byteout.close();
        return bdata;
    }

    public static <T> T deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(bi);
        Object s = objectInputStream.readObject();
        return (T)s;
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[0x400000];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static void createDir(File file) {
        if (file.isDirectory()) {
            if (!file.exists()) {
                file.mkdirs();
            }
        } else {
            file.getParentFile().mkdirs();
        }
    }
}

