/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.tool.jwt;

import com.ygsoft.ecp.service.tool.jwt.JWTCheckResult;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaWebTokenUtil {
    public static final String JWT_ERRCODE_EXPIRE = "JWT_ERRCODE_EXPIRE";
    public static final String JWT_ERRCODE_SIGNATURE_FAIL = "JWT_ERRCODE_SIGNATURE_FAIL";
    private static final String JWT_ERRCODE_FAIL = "JWT_ERRCODE_FAIL";
    private static final String JWT_ISSUER = "tianqingAdmin";
    private static String jwtSecert = "javaWebToken";
    private static SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;

    public static void setJwtSecert(String jwtSecert) {
        JavaWebTokenUtil.jwtSecert = jwtSecert;
    }

    public static void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        JavaWebTokenUtil.signatureAlgorithm = signatureAlgorithm;
    }

    public static SecretKey generalKey() {
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)jwtSecert);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        return signingKey;
    }

    public static String createJWTtoken(String id, String audience, String subject, Map<String, Object> claims, Long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        SecretKey secretKey = JavaWebTokenUtil.generalKey();
        JwtBuilder builder = Jwts.builder().setId(id).setAudience(audience).setClaims(claims).setSubject(subject).setIssuer(JWT_ISSUER).setIssuedAt(now).signWith(signatureAlgorithm, (Key)secretKey);
        if (ttlMillis != null && ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date expDate = new Date(expMillis);
            builder.setExpiration(expDate);
        }
        return builder.compact();
    }

    public static String createJWTtoken(String id, String audience, String subject, Map<String, Object> claims, Date expDate) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        SecretKey secretKey = JavaWebTokenUtil.generalKey();
        JwtBuilder builder = Jwts.builder().setId(id).setAudience(audience).setClaims(claims).setSubject(subject).setIssuer(JWT_ISSUER).setIssuedAt(now).signWith(signatureAlgorithm, (Key)secretKey);
        if (expDate != null) {
            builder.setExpiration(expDate);
        }
        return builder.compact();
    }

    public static JWTCheckResult validateJWT(String jsonWebToken) {
        JWTCheckResult checkResult = new JWTCheckResult();
        Claims claims = null;
        try {
            claims = JavaWebTokenUtil.parseJWT(jsonWebToken);
            checkResult.setSuccess(true);
            checkResult.setClaims(claims);
        }
        catch (ExpiredJwtException e) {
            checkResult.setErrCode(JWT_ERRCODE_EXPIRE);
            checkResult.setSuccess(false);
            checkResult.setCause(e);
        }
        catch (SignatureException e) {
            checkResult.setErrCode(JWT_ERRCODE_SIGNATURE_FAIL);
            checkResult.setSuccess(false);
            checkResult.setCause(e);
        }
        catch (Exception e) {
            checkResult.setErrCode(JWT_ERRCODE_FAIL);
            checkResult.setSuccess(false);
            checkResult.setCause(e);
        }
        return checkResult;
    }

    public static Claims parseJWT(String jsonWebToken) throws Exception {
        SecretKey secretKey = JavaWebTokenUtil.generalKey();
        return (Claims)Jwts.parser().setSigningKey((Key)secretKey).parseClaimsJws(jsonWebToken).getBody();
    }
}

