/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle149.asn1.DERBitString;
import org.bouncycastle149.asn1.crmf.PKMACValue;
import org.bouncycastle149.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle149.cert.crmf.CRMFException;
import org.bouncycastle149.cert.crmf.PKMACBuilder;
import org.bouncycastle149.operator.MacCalculator;

class PKMACValueGenerator {
    private PKMACBuilder builder;

    public PKMACValueGenerator(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public PKMACValue generate(char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return new PKMACValue(macCalculator.getAlgorithmIdentifier(), new DERBitString(macCalculator.getMac()));
    }
}

