/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cms;

import org.bouncycastle149.asn1.DEROctetString;
import org.bouncycastle149.asn1.cms.KEKIdentifier;
import org.bouncycastle149.asn1.cms.KEKRecipientInfo;
import org.bouncycastle149.asn1.cms.RecipientInfo;
import org.bouncycastle149.cms.CMSException;
import org.bouncycastle149.cms.RecipientInfoGenerator;
import org.bouncycastle149.operator.GenericKey;
import org.bouncycastle149.operator.OperatorException;
import org.bouncycastle149.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

