/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cms;

import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import org.bouncycastle149.asn1.ASN1OctetString;
import org.bouncycastle149.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle149.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle149.asn1.cms.RecipientIdentifier;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.cms.AuthAttributesProvider;
import org.bouncycastle149.cms.CMSEnvelopedHelper;
import org.bouncycastle149.cms.CMSException;
import org.bouncycastle149.cms.CMSSecureReadable;
import org.bouncycastle149.cms.CMSTypedStream;
import org.bouncycastle149.cms.CMSUtils;
import org.bouncycastle149.cms.KeyTransRecipient;
import org.bouncycastle149.cms.KeyTransRecipientId;
import org.bouncycastle149.cms.Recipient;
import org.bouncycastle149.cms.RecipientInformation;
import org.bouncycastle149.cms.RecipientOperator;
import org.bouncycastle149.cms.jcajce.JceKeyTransAuthenticatedRecipient;
import org.bouncycastle149.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle149.cms.jcajce.JceKeyTransRecipient;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        try {
            JceKeyTransRecipient jceKeyTransRecipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKeyTransEnvelopedRecipient((PrivateKey)key) : new JceKeyTransAuthenticatedRecipient((PrivateKey)key);
            if (provider != null) {
                jceKeyTransRecipient.setProvider(provider);
                if (provider.getName().equalsIgnoreCase("SunJCE")) {
                    jceKeyTransRecipient.setContentProvider((String)null);
                }
            }
            return this.getContentStream(jceKeyTransRecipient);
        }
        catch (IOException iOException) {
            throw new CMSException("encoding error: " + iOException.getMessage(), iOException);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

