/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cms.bc;

import org.bouncycastle149.asn1.ASN1OctetString;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.cms.CMSException;
import org.bouncycastle149.cms.PasswordRecipient;
import org.bouncycastle149.cms.bc.EnvelopedDataHelper;
import org.bouncycastle149.crypto.InvalidCipherTextException;
import org.bouncycastle149.crypto.Wrapper;
import org.bouncycastle149.crypto.params.KeyParameter;
import org.bouncycastle149.crypto.params.ParametersWithIV;

public abstract class BcPasswordRecipient
implements PasswordRecipient {
    private int schemeID = 1;
    private char[] password;

    BcPasswordRecipient(char[] cArray) {
        this.password = cArray;
    }

    public BcPasswordRecipient setPasswordConversionScheme(int n) {
        this.schemeID = n;
        return this;
    }

    protected KeyParameter extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2) throws CMSException {
        Wrapper wrapper = EnvelopedDataHelper.createRFC3211Wrapper(algorithmIdentifier.getAlgorithm());
        wrapper.init(false, new ParametersWithIV(new KeyParameter(byArray), ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets()));
        try {
            return new KeyParameter(wrapper.unwrap(byArray2, 0, byArray2.length));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new CMSException("unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    public int getPasswordConversionScheme() {
        return this.schemeID;
    }

    public char[] getPassword() {
        return this.password;
    }
}

