/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cms.jcajce;

import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle149.asn1.ASN1OctetString;
import org.bouncycastle149.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle149.asn1.x509.Certificate;
import org.bouncycastle149.asn1.x509.TBSCertificateStructure;
import org.bouncycastle149.asn1.x509.X509Extension;
import org.bouncycastle149.cms.jcajce.DefaultJcaJceExtHelper;
import org.bouncycastle149.cms.jcajce.EnvelopedDataHelper;
import org.bouncycastle149.cms.jcajce.NamedJcaJceExtHelper;
import org.bouncycastle149.cms.jcajce.ProviderJcaJceExtHelper;

class CMSUtils {
    CMSUtils() {
    }

    static TBSCertificateStructure getTBSCertificateStructure(X509Certificate x509Certificate) throws CertificateEncodingException {
        return TBSCertificateStructure.getInstance(x509Certificate.getTBSCertificate());
    }

    static IssuerAndSerialNumber getIssuerAndSerialNumber(X509Certificate x509Certificate) throws CertificateEncodingException {
        Certificate certificate = Certificate.getInstance(x509Certificate.getEncoded());
        return new IssuerAndSerialNumber(certificate.getIssuer(), x509Certificate.getSerialNumber());
    }

    static byte[] getSubjectKeyId(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue(X509Extension.subjectKeyIdentifier.getId());
        if (byArray != null) {
            return ASN1OctetString.getInstance(ASN1OctetString.getInstance(byArray).getOctets()).getOctets();
        }
        return null;
    }

    static EnvelopedDataHelper createContentHelper(Provider provider) {
        if (provider != null) {
            return new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        }
        return new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    }

    static EnvelopedDataHelper createContentHelper(String string) {
        if (string != null) {
            return new EnvelopedDataHelper(new NamedJcaJceExtHelper(string));
        }
        return new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    }
}

