/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cms.jcajce;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle149.cert.X509CertificateHolder;
import org.bouncycastle149.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle149.cms.CMSAttributeTableGenerator;
import org.bouncycastle149.cms.SignerInfoGenerator;
import org.bouncycastle149.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle149.operator.ContentSigner;
import org.bouncycastle149.operator.DigestCalculatorProvider;
import org.bouncycastle149.operator.OperatorCreationException;

public class JcaSignerInfoGeneratorBuilder {
    private SignerInfoGeneratorBuilder builder;

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider) {
        this.builder = new SignerInfoGeneratorBuilder(digestCalculatorProvider);
    }

    public JcaSignerInfoGeneratorBuilder setDirectSignature(boolean bl) {
        this.builder.setDirectSignature(bl);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.builder.setSignedAttributeGenerator(cMSAttributeTableGenerator);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.builder.setUnsignedAttributeGenerator(cMSAttributeTableGenerator);
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        return this.builder.build(contentSigner, x509CertificateHolder);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] byArray) throws OperatorCreationException {
        return this.builder.build(contentSigner, byArray);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509Certificate x509Certificate) throws OperatorCreationException, CertificateEncodingException {
        return this.build(contentSigner, new JcaX509CertificateHolder(x509Certificate));
    }
}

