/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastle149.crypto.BasicAgreement;
import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.params.ECDomainParameters;
import org.bouncycastle149.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle149.crypto.params.ECPublicKeyParameters;
import org.bouncycastle149.math.ec.ECPoint;

public class ECDHCBasicAgreement
implements BasicAgreement {
    ECPrivateKeyParameters key;

    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        ECPoint eCPoint = eCPublicKeyParameters.getQ().multiply(eCDomainParameters.getH().multiply(this.key.getD()));
        return eCPoint.getX().toBigInteger();
    }
}

