/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.ec;

import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.ec.ECDecryptor;
import org.bouncycastle149.crypto.ec.ECPair;
import org.bouncycastle149.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle149.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    public ECPoint decrypt(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECPoint eCPoint = eCPair.getX().multiply(this.key.getD());
        return eCPair.getY().add(eCPoint.negate());
    }
}

