/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle149.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle149.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle149.crypto.KeyGenerationParameters;
import org.bouncycastle149.crypto.params.ECDomainParameters;
import org.bouncycastle149.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle149.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle149.crypto.params.ECPublicKeyParameters;
import org.bouncycastle149.math.ec.ECConstants;
import org.bouncycastle149.math.ec.ECPoint;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        while ((bigInteger = new BigInteger(n, this.random)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        ECPoint eCPoint = this.params.getG().multiply(bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }
}

