/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.modes;

import java.io.ByteArrayOutputStream;
import org.bouncycastle149.crypto.BlockCipher;
import org.bouncycastle149.crypto.CipherParameters;
import org.bouncycastle149.crypto.DataLengthException;
import org.bouncycastle149.crypto.InvalidCipherTextException;
import org.bouncycastle149.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle149.crypto.modes.AEADBlockCipher;
import org.bouncycastle149.crypto.modes.SICBlockCipher;
import org.bouncycastle149.crypto.params.AEADParameters;
import org.bouncycastle149.crypto.params.ParametersWithIV;
import org.bouncycastle149.util.Arrays;

public class CCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher cipher;
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private int macSize;
    private CipherParameters keyParam;
    private byte[] macBlock;
    private ByteArrayOutputStream associatedText = new ByteArrayOutputStream();
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    public CCMBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.macBlock = new byte[this.blockSize];
        if (this.blockSize != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            this.nonce = aEADParameters.getNonce();
            this.initialAssociatedText = aEADParameters.getAssociatedText();
            this.macSize = aEADParameters.getMacSize() / 8;
            this.keyParam = aEADParameters.getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.nonce = parametersWithIV.getIV();
            this.initialAssociatedText = null;
            this.macSize = this.macBlock.length / 2;
            this.keyParam = parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
        if (this.nonce == null || this.nonce.length < 7 || this.nonce.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CCM";
    }

    public void processAADByte(byte by) {
        this.associatedText.write(by);
    }

    public void processAADBytes(byte[] byArray, int n, int n2) {
        this.associatedText.write(byArray, n, n2);
    }

    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        this.data.write(by);
        return 0;
    }

    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.data.write(byArray, n, n2);
        return 0;
    }

    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        byte[] byArray2 = this.data.toByteArray();
        byte[] byArray3 = this.processPacket(byArray2, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
        this.reset();
        return byArray3.length;
    }

    public void reset() {
        this.cipher.reset();
        this.associatedText.reset();
        this.data.reset();
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getUpdateOutputSize(int n) {
        return 0;
    }

    public int getOutputSize(int n) {
        int n2 = n + this.data.size();
        if (this.forEncryption) {
            return n2 + this.macSize;
        }
        return n2 < this.macSize ? 0 : n2 - this.macSize;
    }

    public byte[] processPacket(byte[] byArray, int n, int n2) throws IllegalStateException, InvalidCipherTextException {
        int n3;
        byte[] byArray2;
        int n4;
        if (this.keyParam == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        int n5 = this.nonce.length;
        int n6 = 15 - n5;
        if (n6 < 4 && n2 >= (n4 = 1 << 8 * n6)) {
            throw new IllegalStateException("CCM packet too large for choice of q.");
        }
        byte[] byArray3 = new byte[this.blockSize];
        byArray3[0] = (byte)(n6 - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        SICBlockCipher sICBlockCipher = new SICBlockCipher(this.cipher);
        sICBlockCipher.init(this.forEncryption, new ParametersWithIV(this.keyParam, byArray3));
        int n7 = 0;
        if (this.forEncryption) {
            byArray2 = new byte[n2 + this.macSize];
            this.calculateMac(byArray, n, n2, this.macBlock);
            sICBlockCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (n3 = n; n3 < n2 - this.blockSize; n3 += this.blockSize) {
                sICBlockCipher.processBlock(byArray, n3, byArray2, n7);
                n7 += this.blockSize;
            }
            byte[] byArray4 = new byte[this.blockSize];
            System.arraycopy(byArray, n3, byArray4, 0, n2 - n3);
            sICBlockCipher.processBlock(byArray4, 0, byArray4, 0);
            System.arraycopy(byArray4, 0, byArray2, n7, n2 - n3);
            System.arraycopy(this.macBlock, 0, byArray2, n7 += n2 - n3, byArray2.length - n7);
        } else {
            byArray2 = new byte[n2 - this.macSize];
            System.arraycopy(byArray, n + n2 - this.macSize, this.macBlock, 0, this.macSize);
            sICBlockCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (int i = this.macSize; i != this.macBlock.length; ++i) {
                this.macBlock[i] = 0;
            }
            while (n7 < byArray2.length - this.blockSize) {
                sICBlockCipher.processBlock(byArray, n3, byArray2, n7);
                n7 += this.blockSize;
                n3 += this.blockSize;
            }
            byte[] byArray5 = new byte[this.blockSize];
            System.arraycopy(byArray, n3, byArray5, 0, byArray2.length - n7);
            sICBlockCipher.processBlock(byArray5, 0, byArray5, 0);
            System.arraycopy(byArray5, 0, byArray2, n7, byArray2.length - n7);
            byte[] byArray6 = new byte[this.blockSize];
            this.calculateMac(byArray2, 0, byArray2.length, byArray6);
            if (!Arrays.constantTimeAreEqual(this.macBlock, byArray6)) {
                throw new InvalidCipherTextException("mac check in CCM failed");
            }
        }
        return byArray2;
    }

    private int calculateMac(byte[] byArray, int n, int n2, byte[] byArray2) {
        CBCBlockCipherMac cBCBlockCipherMac = new CBCBlockCipherMac(this.cipher, this.macSize * 8);
        cBCBlockCipherMac.init(this.keyParam);
        byte[] byArray3 = new byte[16];
        if (this.hasAssociatedText()) {
            byArray3[0] = (byte)(byArray3[0] | 0x40);
        }
        byArray3[0] = (byte)(byArray3[0] | ((cBCBlockCipherMac.getMacSize() - 2) / 2 & 7) << 3);
        byArray3[0] = (byte)(byArray3[0] | 15 - this.nonce.length - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        int n3 = n2;
        int n4 = 1;
        while (n3 > 0) {
            byArray3[byArray3.length - n4] = (byte)(n3 & 0xFF);
            n3 >>>= 8;
            ++n4;
        }
        cBCBlockCipherMac.update(byArray3, 0, byArray3.length);
        if (this.hasAssociatedText()) {
            int n5;
            int n6 = this.getAssociatedTextLength();
            if (n6 < 65280) {
                cBCBlockCipherMac.update((byte)(n6 >> 8));
                cBCBlockCipherMac.update((byte)n6);
                n5 = 2;
            } else {
                cBCBlockCipherMac.update((byte)-1);
                cBCBlockCipherMac.update((byte)-2);
                cBCBlockCipherMac.update((byte)(n6 >> 24));
                cBCBlockCipherMac.update((byte)(n6 >> 16));
                cBCBlockCipherMac.update((byte)(n6 >> 8));
                cBCBlockCipherMac.update((byte)n6);
                n5 = 6;
            }
            if (this.initialAssociatedText != null) {
                cBCBlockCipherMac.update(this.initialAssociatedText, 0, this.initialAssociatedText.length);
            }
            if (this.associatedText.size() > 0) {
                byte[] byArray4 = this.associatedText.toByteArray();
                cBCBlockCipherMac.update(byArray4, 0, byArray4.length);
            }
            if ((n5 = (n5 + n6) % 16) != 0) {
                for (int i = n5; i != 16; ++i) {
                    cBCBlockCipherMac.update((byte)0);
                }
            }
        }
        cBCBlockCipherMac.update(byArray, n, n2);
        return cBCBlockCipherMac.doFinal(byArray2, 0);
    }

    private int getAssociatedTextLength() {
        return this.associatedText.size() + (this.initialAssociatedText == null ? 0 : this.initialAssociatedText.length);
    }

    private boolean hasAssociatedText() {
        return this.getAssociatedTextLength() > 0;
    }
}

