/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.tls;

import java.io.IOException;
import org.bouncycastle149.crypto.CryptoException;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle149.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle149.crypto.params.RSAKeyParameters;
import org.bouncycastle149.crypto.tls.Certificate;
import org.bouncycastle149.crypto.tls.TlsContext;
import org.bouncycastle149.crypto.tls.TlsDSSSigner;
import org.bouncycastle149.crypto.tls.TlsECDSASigner;
import org.bouncycastle149.crypto.tls.TlsFatalAlert;
import org.bouncycastle149.crypto.tls.TlsRSASigner;
import org.bouncycastle149.crypto.tls.TlsSigner;
import org.bouncycastle149.crypto.tls.TlsSignerCredentials;

public class DefaultTlsSignerCredentials
implements TlsSignerCredentials {
    protected TlsContext context;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;
    protected TlsSigner signer;

    public DefaultTlsSignerCredentials(TlsContext tlsContext, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            this.signer = new TlsRSASigner();
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            this.signer = new TlsDSSSigner();
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.signer = new TlsECDSASigner();
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.signer.init(tlsContext);
        this.context = tlsContext;
        this.certificate = certificate;
        this.privateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] generateCertificateSignature(byte[] byArray) throws IOException {
        try {
            return this.signer.generateRawSignature(this.privateKey, byArray);
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80);
        }
    }
}

