/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.tls;

import java.io.IOException;
import org.bouncycastle149.crypto.tls.AbstractTlsClient;
import org.bouncycastle149.crypto.tls.TlsCipher;
import org.bouncycastle149.crypto.tls.TlsCipherFactory;
import org.bouncycastle149.crypto.tls.TlsFatalAlert;
import org.bouncycastle149.crypto.tls.TlsKeyExchange;
import org.bouncycastle149.crypto.tls.TlsPSKIdentity;
import org.bouncycastle149.crypto.tls.TlsPSKKeyExchange;

public abstract class PSKTlsClient
extends AbstractTlsClient {
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity tlsPSKIdentity) {
        this.pskIdentity = tlsPSKIdentity;
    }

    public PSKTlsClient(TlsCipherFactory tlsCipherFactory, TlsPSKIdentity tlsPSKIdentity) {
        super(tlsCipherFactory);
        this.pskIdentity = tlsPSKIdentity;
    }

    public int[] getCipherSuites() {
        return new int[]{145, 144, 143, 142, 149, 148, 147, 146, 141, 140, 139, 138};
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 44: 
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                return this.createPSKKeyExchange(13);
            }
            case 46: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                return this.createPSKKeyExchange(15);
            }
            case 45: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                return this.createPSKKeyExchange(14);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 139: 
            case 143: 
            case 147: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 140: 
            case 144: 
            case 148: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 141: 
            case 145: 
            case 149: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
            case 44: 
            case 45: 
            case 46: {
                return this.cipherFactory.createCipher(this.context, 0, 2);
            }
            case 138: 
            case 142: 
            case 146: {
                return this.cipherFactory.createCipher(this.context, 2, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n) {
        return new TlsPSKKeyExchange(n, this.supportedSignatureAlgorithms, this.pskIdentity);
    }
}

