/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle149.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle149.crypto.CryptoException;
import org.bouncycastle149.crypto.Signer;
import org.bouncycastle149.crypto.agreement.srp.SRP6Client;
import org.bouncycastle149.crypto.agreement.srp.SRP6Util;
import org.bouncycastle149.crypto.digests.SHA1Digest;
import org.bouncycastle149.crypto.io.SignerInputStream;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.tls.AbstractTlsKeyExchange;
import org.bouncycastle149.crypto.tls.Certificate;
import org.bouncycastle149.crypto.tls.CertificateRequest;
import org.bouncycastle149.crypto.tls.SecurityParameters;
import org.bouncycastle149.crypto.tls.TlsContext;
import org.bouncycastle149.crypto.tls.TlsCredentials;
import org.bouncycastle149.crypto.tls.TlsDSSSigner;
import org.bouncycastle149.crypto.tls.TlsFatalAlert;
import org.bouncycastle149.crypto.tls.TlsRSASigner;
import org.bouncycastle149.crypto.tls.TlsSigner;
import org.bouncycastle149.crypto.tls.TlsUtils;
import org.bouncycastle149.crypto.util.PublicKeyFactory;
import org.bouncycastle149.util.BigIntegers;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSigner tlsSigner;
    protected byte[] identity;
    protected byte[] password;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected byte[] s = null;
    protected BigInteger B = null;
    protected SRP6Client srpClient = new SRP6Client();

    public TlsSRPKeyExchange(int n, Vector vector, byte[] byArray, byte[] byArray2) {
        super(n, vector);
        switch (n) {
            case 21: {
                this.tlsSigner = null;
                break;
            }
            case 23: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 22: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.keyExchange = n;
        this.identity = byArray;
        this.password = byArray2;
    }

    public void init(TlsContext tlsContext) {
        super.init(tlsContext);
        if (this.tlsSigner != null) {
            this.tlsSigner.init(tlsContext);
        }
    }

    public void skipServerCredentials() throws IOException {
        if (this.tlsSigner != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.tlsSigner == null) {
            throw new TlsFatalAlert(10);
        }
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        org.bouncycastle149.asn1.x509.Certificate certificate2 = certificate.getCertificateAt(0);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate2.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43);
        }
        if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(certificate2, 128);
        super.processServerCertificate(certificate);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        Object object;
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        InputStream inputStream2 = inputStream;
        Signer signer = null;
        if (this.tlsSigner != null) {
            signer = this.initVerifyer(this.tlsSigner, securityParameters);
            inputStream2 = new SignerInputStream(inputStream, signer);
        }
        byte[] byArray = TlsUtils.readOpaque16(inputStream2);
        byte[] byArray2 = TlsUtils.readOpaque16(inputStream2);
        byte[] byArray3 = TlsUtils.readOpaque8(inputStream2);
        byte[] byArray4 = TlsUtils.readOpaque16(inputStream2);
        if (signer != null && !signer.verifySignature((byte[])(object = TlsUtils.readOpaque16(inputStream)))) {
            throw new TlsFatalAlert(51);
        }
        object = new BigInteger(1, byArray);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        this.s = byArray3;
        try {
            this.B = SRP6Util.validatePublicValue((BigInteger)object, new BigInteger(1, byArray4));
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47);
        }
        this.srpClient.init((BigInteger)object, bigInteger, new SHA1Digest(), this.context.getSecureRandom());
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        byte[] byArray = BigIntegers.asUnsignedByteArray(this.srpClient.generateClientCredentials(this.s, this.identity, this.password));
        TlsUtils.writeOpaque16(byArray, outputStream);
    }

    public byte[] generatePremasterSecret() throws IOException {
        try {
            return BigIntegers.asUnsignedByteArray(this.srpClient.calculateSecret(this.B));
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(47);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

