/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle149.asn1.ASN1Encodable;
import org.bouncycastle149.asn1.ASN1InputStream;
import org.bouncycastle149.asn1.ASN1Integer;
import org.bouncycastle149.asn1.ASN1Object;
import org.bouncycastle149.asn1.ASN1ObjectIdentifier;
import org.bouncycastle149.asn1.ASN1Primitive;
import org.bouncycastle149.asn1.ASN1Sequence;
import org.bouncycastle149.asn1.nist.NISTNamedCurves;
import org.bouncycastle149.asn1.oiw.ElGamalParameter;
import org.bouncycastle149.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle149.asn1.pkcs.DHParameter;
import org.bouncycastle149.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle149.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle149.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle149.asn1.sec.ECPrivateKey;
import org.bouncycastle149.asn1.sec.SECNamedCurves;
import org.bouncycastle149.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.asn1.x509.DSAParameter;
import org.bouncycastle149.asn1.x9.X962NamedCurves;
import org.bouncycastle149.asn1.x9.X962Parameters;
import org.bouncycastle149.asn1.x9.X9ECParameters;
import org.bouncycastle149.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.params.DHParameters;
import org.bouncycastle149.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle149.crypto.params.DSAParameters;
import org.bouncycastle149.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle149.crypto.params.ECDomainParameters;
import org.bouncycastle149.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle149.crypto.params.ElGamalParameters;
import org.bouncycastle149.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle149.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
            return new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
        }
        if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter dHParameter = DHParameter.getInstance(algorithmIdentifier.getParameters());
            ASN1Integer aSN1Integer = (ASN1Integer)privateKeyInfo.parsePrivateKey();
            BigInteger bigInteger = dHParameter.getL();
            int n = bigInteger == null ? 0 : bigInteger.intValue();
            DHParameters dHParameters = new DHParameters(dHParameter.getP(), dHParameter.getG(), null, n);
            return new DHPrivateKeyParameters(aSN1Integer.getValue(), dHParameters);
        }
        if (algorithmIdentifier.getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elGamalParameter = new ElGamalParameter((ASN1Sequence)algorithmIdentifier.getParameters());
            ASN1Integer aSN1Integer = (ASN1Integer)privateKeyInfo.parsePrivateKey();
            return new ElGamalPrivateKeyParameters(aSN1Integer.getValue(), new ElGamalParameters(elGamalParameter.getP(), elGamalParameter.getG()));
        }
        if (algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.id_dsa)) {
            ASN1Integer aSN1Integer = (ASN1Integer)privateKeyInfo.parsePrivateKey();
            ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
            DSAParameters dSAParameters = null;
            if (aSN1Encodable != null) {
                DSAParameter dSAParameter = DSAParameter.getInstance(aSN1Encodable.toASN1Primitive());
                dSAParameters = new DSAParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
            }
            return new DSAPrivateKeyParameters(aSN1Integer.getValue(), dSAParameters);
        }
        if (algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X9ECParameters x9ECParameters;
            ASN1Object aSN1Object;
            X962Parameters x962Parameters = new X962Parameters((ASN1Primitive)algorithmIdentifier.getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1Object = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
                x9ECParameters = X962NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1Object);
                if (x9ECParameters == null && (x9ECParameters = SECNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1Object)) == null && (x9ECParameters = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1Object)) == null) {
                    x9ECParameters = TeleTrusTNamedCurves.getByOID((ASN1ObjectIdentifier)aSN1Object);
                }
            } else {
                x9ECParameters = X9ECParameters.getInstance(x962Parameters.getParameters());
            }
            aSN1Object = ECPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
            BigInteger bigInteger = ((ECPrivateKey)aSN1Object).getKey();
            ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            return new ECPrivateKeyParameters(bigInteger, eCDomainParameters);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

