/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.crypto.util;

import java.io.IOException;
import org.bouncycastle149.asn1.ASN1Encodable;
import org.bouncycastle149.asn1.ASN1Integer;
import org.bouncycastle149.asn1.DERNull;
import org.bouncycastle149.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle149.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle149.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.asn1.x509.DSAParameter;
import org.bouncycastle149.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.params.DSAParameters;
import org.bouncycastle149.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle149.crypto.params.RSAKeyParameters;
import org.bouncycastle149.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyInfoFactory {
    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), new RSAPrivateKey(rSAPrivateCrtKeyParameters.getModulus(), rSAPrivateCrtKeyParameters.getPublicExponent(), rSAPrivateCrtKeyParameters.getExponent(), rSAPrivateCrtKeyParameters.getP(), rSAPrivateCrtKeyParameters.getQ(), rSAPrivateCrtKeyParameters.getDP(), rSAPrivateCrtKeyParameters.getDQ(), rSAPrivateCrtKeyParameters.getQInv()));
        }
        if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters dSAPrivateKeyParameters = (DSAPrivateKeyParameters)asymmetricKeyParameter;
            DSAParameters dSAParameters = dSAPrivateKeyParameters.getParameters();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG())), new ASN1Integer(dSAPrivateKeyParameters.getX()));
        }
        throw new IOException("key parameters not recognised.");
    }
}

