/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.jcajce.provider.digest;

import org.bouncycastle149.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle149.crypto.CipherKeyGenerator;
import org.bouncycastle149.crypto.digests.MD4Digest;
import org.bouncycastle149.crypto.macs.HMac;
import org.bouncycastle149.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle149.jcajce.provider.digest.BCMessageDigest;
import org.bouncycastle149.jcajce.provider.digest.DigestAlgorithmProvider;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseMac;

public class MD4 {
    private MD4() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD4Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new MD4Digest((MD4Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD4Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD4", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD4.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.MD4", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md4, "MD4");
            this.addHMACAlgorithm(configurableProvider, "MD4", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }
}

